/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.settings;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.features.PointsManager;
import studio.magemonkey.genesis.settings.SettingsProperty;
import studio.magemonkey.genesis.settings.ShopItemProperty;
import studio.magemonkey.genesis.settings.ShopProperty;

public class Settings {
    public static final int HIDE_ITEMS_PLAYERS_DONT_HAVE_PERMISSIONS_FOR = 0;
    public static final int ALLOW_UNSAFE_ENCHANTMENTS = 1;
    public static final int ALLOW_SELLING_GREATER_ENCHANTS = 2;
    public static final int CLOSE_SHOP_AFTER_PURCHASE = 3;
    public static final int CLICK_DELAY = 4;
    public static final int SOUND_SHOPITEM_PURCHASE = 5;
    public static final int SOUND_SHOPITEM_CLICK = 6;
    public static final int SOUND_SHOPITEM_NOPERMISSION = 7;
    public static final int SOUND_SHOPITEM_NOTENOUGHMONEY = 8;
    public static final int SOUND_SHOP_OPEN = 9;
    public static final int SOUND_SHOP_CLOSE = 10;
    public static final int SOUND_SHOP_CHANGE_PAGE = 11;
    public static final int SOUND_SHOP_CHANGE_SHOP = 12;
    private boolean moneyEnabled;
    private boolean pointsEnabled;
    private boolean vaultEnabled;
    private boolean permissionsEnabled;
    private boolean bungeeCordServerEnabled;
    private boolean loadSubFoldersEnabled;
    private boolean transactionLogEnabled;
    private boolean checkStackSize;
    private boolean expUseLevel;
    private boolean serverPingingFixConnector;
    private boolean itemAllShowFinalReward;
    private boolean inventoryFullDropItems;
    private boolean allowSellingDamagedItems;
    private boolean reloadAfterCreateShop;
    private boolean signs;
    private boolean pointsDisplay;
    private boolean moneyDisplay;
    private boolean serverPinging;
    private boolean shopCommands;
    private boolean purchaseAsync;
    private boolean metrics = true;
    private int serverPingingSpeed;
    private int serverPingingWaitTime;
    private int serverPingingTimeout;
    private int autoRefreshSpeed;
    private int maxLineLength;
    private int numberGroupingSize;
    private int inputTimeout;
    private String mainShop;
    private String numberLocale;
    private PointsManager.PointsPlugin pointsPlugin;
    private List<String> moneyFormatting;
    private List<String> pointsFormatting;
    private boolean debugEnabled;
    private final Map<Integer, SettingsProperty> properties = new LinkedHashMap<Integer, SettingsProperty>();
    private String language;

    public void loadConfig(ConfigurationSection config) {
        this.properties.clear();
        this.properties.put(0, new ShopItemProperty(config, "HideItemsPlayersDoNotHavePermissionsFor", Boolean.class));
        this.properties.put(1, new ShopItemProperty(config, "AllowUnsafeEnchantments", Boolean.class));
        this.properties.put(2, new ShopItemProperty(config, "CanPlayersSellItemsWithGreaterEnchants", Boolean.class));
        this.properties.put(3, new ShopItemProperty(config, "CloseShopAfterPurchase", Boolean.class));
        this.properties.put(4, new ShopItemProperty(config, "ClickDelay", Integer.class));
        this.properties.put(5, new ShopItemProperty(config, "Sound.Shopitem.Purchase", String.class));
        this.properties.put(6, new ShopItemProperty(config, "Sound.Shopitem.Click", String.class));
        this.properties.put(7, new ShopItemProperty(config, "Sound.Shopitem.NoPermission", String.class));
        this.properties.put(8, new ShopItemProperty(config, "Sound.Shopitem.NotEnoughMoney", String.class));
        this.properties.put(9, new ShopProperty(config, "Sound.Shop.Open", String.class));
        this.properties.put(10, new ShopProperty(config, "Sound.Shop.Close", String.class));
        this.properties.put(11, new ShopProperty(config, "Sound.Shop.ChangePage", String.class));
        this.properties.put(12, new ShopProperty(config, "Sound.Shop.ChangeShop", String.class));
    }

    public void update(Object o) {
        for (SettingsProperty property : this.properties.values()) {
            property.update(o);
        }
    }

    public void update() {
        FileConfiguration mainConfig = ClassManager.manager.getPlugin().getConfig();
        for (SettingsProperty property : this.properties.values()) {
            property.load((ConfigurationSection)mainConfig);
        }
    }

    public SettingsProperty getProperty(int id) {
        return this.properties.get(id);
    }

    public boolean getPropertyBoolean(int id, Object input) {
        SettingsProperty property = this.getProperty(id);
        if (property != null) {
            return property.getBoolean(input);
        }
        return false;
    }

    public int getPropertyInt(int id, Object input, int def) {
        SettingsProperty property = this.getProperty(id);
        if (property != null) {
            return property.getInt(input);
        }
        return def;
    }

    public String getPropertyString(int id, Object input, String def) {
        SettingsProperty property = this.getProperty(id);
        if (property != null) {
            return property.getString(input);
        }
        return def;
    }

    public void setPurchaseAsyncEnabled(boolean b) {
        this.purchaseAsync = b;
    }

    public void setServerPingingEnabled(boolean b) {
        this.serverPinging = b;
    }

    public boolean getMetricsEnabled() {
        return this.metrics;
    }

    public void setMetricsEnabled(boolean b) {
        this.metrics = b;
    }

    public boolean getShopCommandsEnabled() {
        return this.shopCommands;
    }

    public void setShopCommandsEnabled(boolean b) {
        this.shopCommands = b;
    }

    public boolean getSignsEnabled() {
        return this.signs;
    }

    public void setSignsEnabled(boolean b) {
        this.signs = b;
        if (ClassManager.manager.getPlugin().getSignListener() != null) {
            ClassManager.manager.getPlugin().getSignListener().setSignsEnabled(b);
        }
    }

    public boolean getMoneyEnabled() {
        return this.moneyEnabled;
    }

    public boolean getPointsEnabled() {
        return this.pointsEnabled;
    }

    public boolean getVaultEnabled() {
        return this.vaultEnabled;
    }

    public boolean getPermissionsEnabled() {
        return this.permissionsEnabled;
    }

    public boolean getPurchaseAsync() {
        return this.purchaseAsync;
    }

    public boolean getExpUseLevel() {
        return this.expUseLevel;
    }

    public boolean getBungeeCordServerEnabled() {
        return this.bungeeCordServerEnabled;
    }

    public boolean getBalanceVariableEnabled() {
        return this.moneyDisplay;
    }

    public void setBalanceVariableEnabled(boolean b) {
        this.moneyDisplay = b;
    }

    public boolean getBalancePointsVariableEnabled() {
        return this.pointsDisplay;
    }

    public void setBalancePointsVariableEnabled(boolean b) {
        this.pointsDisplay = b;
    }

    public boolean getTransactionLogEnabled() {
        return this.transactionLogEnabled;
    }

    public boolean getServerPingingEnabled(boolean checkIfLoadedAlready) {
        if (checkIfLoadedAlready) {
            return ClassManager.manager.getServerPingingManager() != null;
        }
        return this.serverPinging;
    }

    public boolean getServerPingingFixConnector() {
        return this.serverPingingFixConnector;
    }

    public boolean getInventoryFullDropItems() {
        return this.inventoryFullDropItems;
    }

    public boolean getLoadSubFoldersEnabled() {
        return this.loadSubFoldersEnabled;
    }

    public boolean getCheckStackSize() {
        return this.checkStackSize;
    }

    public boolean getItemAllShowFinalReward() {
        return this.itemAllShowFinalReward;
    }

    public boolean getAllowSellingDamagedItems() {
        return this.allowSellingDamagedItems;
    }

    public boolean getReloadAfterCreateShop() {
        return this.reloadAfterCreateShop;
    }

    @Generated
    public void setMoneyEnabled(boolean moneyEnabled) {
        this.moneyEnabled = moneyEnabled;
    }

    @Generated
    public void setPointsEnabled(boolean pointsEnabled) {
        this.pointsEnabled = pointsEnabled;
    }

    @Generated
    public void setVaultEnabled(boolean vaultEnabled) {
        this.vaultEnabled = vaultEnabled;
    }

    @Generated
    public void setPermissionsEnabled(boolean permissionsEnabled) {
        this.permissionsEnabled = permissionsEnabled;
    }

    @Generated
    public void setBungeeCordServerEnabled(boolean bungeeCordServerEnabled) {
        this.bungeeCordServerEnabled = bungeeCordServerEnabled;
    }

    @Generated
    public void setLoadSubFoldersEnabled(boolean loadSubFoldersEnabled) {
        this.loadSubFoldersEnabled = loadSubFoldersEnabled;
    }

    @Generated
    public void setTransactionLogEnabled(boolean transactionLogEnabled) {
        this.transactionLogEnabled = transactionLogEnabled;
    }

    @Generated
    public void setCheckStackSize(boolean checkStackSize) {
        this.checkStackSize = checkStackSize;
    }

    @Generated
    public void setExpUseLevel(boolean expUseLevel) {
        this.expUseLevel = expUseLevel;
    }

    @Generated
    public void setServerPingingFixConnector(boolean serverPingingFixConnector) {
        this.serverPingingFixConnector = serverPingingFixConnector;
    }

    @Generated
    public void setItemAllShowFinalReward(boolean itemAllShowFinalReward) {
        this.itemAllShowFinalReward = itemAllShowFinalReward;
    }

    @Generated
    public void setInventoryFullDropItems(boolean inventoryFullDropItems) {
        this.inventoryFullDropItems = inventoryFullDropItems;
    }

    @Generated
    public void setAllowSellingDamagedItems(boolean allowSellingDamagedItems) {
        this.allowSellingDamagedItems = allowSellingDamagedItems;
    }

    @Generated
    public void setReloadAfterCreateShop(boolean reloadAfterCreateShop) {
        this.reloadAfterCreateShop = reloadAfterCreateShop;
    }

    @Generated
    public int getServerPingingSpeed() {
        return this.serverPingingSpeed;
    }

    @Generated
    public int getServerPingingWaitTime() {
        return this.serverPingingWaitTime;
    }

    @Generated
    public int getServerPingingTimeout() {
        return this.serverPingingTimeout;
    }

    @Generated
    public int getAutoRefreshSpeed() {
        return this.autoRefreshSpeed;
    }

    @Generated
    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    @Generated
    public int getNumberGroupingSize() {
        return this.numberGroupingSize;
    }

    @Generated
    public int getInputTimeout() {
        return this.inputTimeout;
    }

    @Generated
    public void setServerPingingSpeed(int serverPingingSpeed) {
        this.serverPingingSpeed = serverPingingSpeed;
    }

    @Generated
    public void setServerPingingWaitTime(int serverPingingWaitTime) {
        this.serverPingingWaitTime = serverPingingWaitTime;
    }

    @Generated
    public void setServerPingingTimeout(int serverPingingTimeout) {
        this.serverPingingTimeout = serverPingingTimeout;
    }

    @Generated
    public void setAutoRefreshSpeed(int autoRefreshSpeed) {
        this.autoRefreshSpeed = autoRefreshSpeed;
    }

    @Generated
    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    @Generated
    public void setNumberGroupingSize(int numberGroupingSize) {
        this.numberGroupingSize = numberGroupingSize;
    }

    @Generated
    public void setInputTimeout(int inputTimeout) {
        this.inputTimeout = inputTimeout;
    }

    @Generated
    public String getMainShop() {
        return this.mainShop;
    }

    @Generated
    public String getNumberLocale() {
        return this.numberLocale;
    }

    @Generated
    public void setMainShop(String mainShop) {
        this.mainShop = mainShop;
    }

    @Generated
    public void setNumberLocale(String numberLocale) {
        this.numberLocale = numberLocale;
    }

    @Generated
    public void setPointsPlugin(PointsManager.PointsPlugin pointsPlugin) {
        this.pointsPlugin = pointsPlugin;
    }

    @Generated
    public PointsManager.PointsPlugin getPointsPlugin() {
        return this.pointsPlugin;
    }

    @Generated
    public List<String> getMoneyFormatting() {
        return this.moneyFormatting;
    }

    @Generated
    public List<String> getPointsFormatting() {
        return this.pointsFormatting;
    }

    @Generated
    public void setMoneyFormatting(List<String> moneyFormatting) {
        this.moneyFormatting = moneyFormatting;
    }

    @Generated
    public void setPointsFormatting(List<String> pointsFormatting) {
        this.pointsFormatting = pointsFormatting;
    }

    @Generated
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Generated
    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }
}

