/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.pointsystem;

import java.util.LinkedHashMap;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPlugin;

public class GenesisPointsAPI {
    private static final LinkedHashMap<String, GenesisPointsPlugin> interfaces = new LinkedHashMap();

    public static void register(GenesisPointsPlugin points) {
        interfaces.put(points.getName(), points);
    }

    public static GenesisPointsPlugin get(String name) {
        if (name != null) {
            GenesisPointsPlugin p = interfaces.get(name);
            if (p != null) {
                return p;
            }
            for (GenesisPointsPlugin api : interfaces.values()) {
                if (!api.getName().equalsIgnoreCase(name)) continue;
                return api;
            }
            for (GenesisPointsPlugin api : interfaces.values()) {
                for (String nickname : api.getNicknames()) {
                    if (!nickname.equalsIgnoreCase(name)) continue;
                    return api;
                }
            }
        }
        return null;
    }

    public static GenesisPointsPlugin getFirstAvailable() {
        for (GenesisPointsPlugin api : interfaces.values()) {
            if (!api.isAvailable()) continue;
            return api;
        }
        return null;
    }
}

