/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.misc.userinput;

import java.util.UUID;
import org.bukkit.entity.Player;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.misc.userinput.GenesisUserInput;

public class GenesisChatUserInput {
    private final UUID uuid;
    private final GenesisUserInput input;
    private final long time;

    public GenesisChatUserInput(Player p, GenesisUserInput input, long allowedDelay) {
        this.uuid = p.getUniqueId();
        this.input = input;
        this.time = System.currentTimeMillis() + allowedDelay;
        if (ClassManager.manager.getSettings().getBungeeCordServerEnabled()) {
            ClassManager.manager.getBungeeCordManager().playerInputNotification(p, "start", String.valueOf(this.time));
        }
    }

    public boolean isUpToDate() {
        return this.time > System.currentTimeMillis();
    }

    public boolean isCorrectPlayer(Player p) {
        return p.getUniqueId().equals(this.uuid);
    }

    public void input(Player p, String text) {
        this.input.receivedInput(p, text);
        if (ClassManager.manager.getSettings().getBungeeCordServerEnabled()) {
            ClassManager.manager.getBungeeCordManager().playerInputNotification(p, "end", null);
        }
    }
}

