/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.managers.misc.InputReader;
import studio.magemonkey.genesis.misc.EnumUT;

public class Misc {
    public static List<String> fixLore(List<String> itemData) {
        HashMap<Integer, String> lore = null;
        ArrayList<String> newList = null;
        int highest = -1;
        for (String line : itemData) {
            String[] parts;
            String start;
            if (!line.toLowerCase().startsWith("lore") || (start = (parts = line.split(":", 2))[0]).length() <= "lore".length()) continue;
            try {
                int i = Integer.parseInt(start.replace("lore", "")) - 1;
                if (lore == null) {
                    lore = new HashMap<Integer, String>();
                    newList = new ArrayList<String>();
                }
                lore.put(i, parts[1]);
                highest = Math.max(highest, i);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (newList != null) {
            for (String line : itemData) {
                if (line.toLowerCase().startsWith("lore")) continue;
                newList.add(line);
            }
            for (int i = 0; i <= highest; ++i) {
                Object s = "lore:";
                if (lore.containsKey(i)) {
                    s = (String)s + (String)lore.get(i);
                }
                newList.add((String)s);
            }
        }
        if (newList != null) {
            return newList;
        }
        return itemData;
    }

    public static void playSound(Player p, String sound) {
        if (sound == null || sound.isEmpty()) {
            return;
        }
        String[] parts = sound.split(":");
        Object s = null;
        if (parts.length == 3) {
            for (Sound e : EnumUT.values(Sound.class)) {
                if (!EnumUT.name(e).equalsIgnoreCase(parts[0]) && !e.getKey().getKey().equalsIgnoreCase(parts[0])) continue;
                s = e.getKey().getKey();
                break;
            }
        } else {
            s = parts[0] + ":" + parts[1];
        }
        if (s != null) {
            float volume;
            boolean isCustomSound = ((String)s).contains(":");
            float pitch = 1.0f;
            if (!isCustomSound) {
                volume = (float)InputReader.getDouble(parts[1], 1.0);
                if (parts.length >= 3) {
                    pitch = (float)InputReader.getDouble(parts[2], 1.0);
                }
            } else {
                volume = (float)InputReader.getDouble(parts[2], 1.0);
                if (parts.length >= 4) {
                    pitch = (float)InputReader.getDouble(parts[3], 1.0);
                }
            }
            p.playSound(p.getLocation(), (String)s, SoundCategory.NEUTRAL, volume, pitch);
        }
    }

    public static ItemStack getItemInMainHand(Player p) {
        ItemStack item;
        try {
            item = p.getInventory().getItemInMainHand();
        }
        catch (NoSuchMethodError e) {
            item = p.getItemInHand();
        }
        return item;
    }
}

