/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.misc;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.misc.MathTools;

public class CurrencyTools {
    public static boolean hasValue(Player p, GenesisCurrency currency, double value, boolean failMessage) {
        switch (currency.ordinal()) {
            case 1: {
                if ((double)p.getLevel() < value) {
                    if (failMessage) {
                        ClassManager.manager.getMessageHandler().sendMessage("NotEnough.Exp", (CommandSender)p);
                    }
                    return false;
                }
                return true;
            }
            case 0: {
                if (ClassManager.manager.getVaultHandler() == null) {
                    return false;
                }
                if (ClassManager.manager.getVaultHandler().getEconomy() == null) {
                    return false;
                }
                if (!ClassManager.manager.getVaultHandler().getEconomy().hasAccount(p.getName())) {
                    if (failMessage) {
                        ClassManager.manager.getMessageHandler().sendMessage("Economy.NoAccount", (CommandSender)p);
                    }
                    return false;
                }
                if (ClassManager.manager.getVaultHandler().getEconomy().getBalance(p.getName()) < value) {
                    if (failMessage) {
                        ClassManager.manager.getMessageHandler().sendMessage("NotEnough.Money", (CommandSender)p);
                    }
                    return false;
                }
                return true;
            }
            case 2: {
                if (ClassManager.manager.getPointsManager().getPoints((OfflinePlayer)p) < value) {
                    ClassManager.manager.getMessageHandler().sendMessage("NotEnough.Points", (CommandSender)p);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static String takePrice(Player p, GenesisCurrency currency, double cost) {
        switch (currency.ordinal()) {
            case 1: {
                p.setLevel(p.getLevel() - (int)cost);
                int balanceExp = p.getLevel();
                return ClassManager.manager.getMessageHandler().get("Display.Exp").replace("%levels%", MathTools.displayNumber((double)balanceExp, GenesisPriceType.Exp));
            }
            case 0: {
                if (!ClassManager.manager.getVaultHandler().getEconomy().hasAccount(p.getName())) {
                    ClassManager.manager.getBugFinder().severe("Unable to take money! No economy account existing! (" + p.getName() + ", " + cost + ")");
                    return "";
                }
                ClassManager.manager.getVaultHandler().getEconomy().withdrawPlayer(p.getName(), cost);
                double balance = ClassManager.manager.getVaultHandler().getEconomy().getBalance(p.getName());
                return ClassManager.manager.getMessageHandler().get("Display.Money").replace("%money%", MathTools.displayNumber(balance, GenesisPriceType.Money));
            }
            case 2: {
                double balancePoints = ClassManager.manager.getPointsManager().takePoints((OfflinePlayer)p, cost);
                return ClassManager.manager.getMessageHandler().get("Display.Points").replace("%points%", MathTools.displayNumber(balancePoints, GenesisPriceType.Points));
            }
        }
        return "";
    }

    public static void giveReward(Player p, GenesisCurrency currency, double reward) {
        switch (currency.ordinal()) {
            case 1: {
                p.setLevel(p.getLevel() + (int)reward);
                return;
            }
            case 0: {
                if (ClassManager.manager.getVaultHandler() == null) {
                    ClassManager.manager.getBugFinder().severe("Unable to give " + p.getName() + " his/her money: Vault manager not loaded. Property: " + ClassManager.manager.getSettings().getVaultEnabled());
                    return;
                }
                if (ClassManager.manager.getVaultHandler().getEconomy() == null) {
                    ClassManager.manager.getBugFinder().severe("Unable to give " + p.getName() + " his/her money: Economy manager not loaded. Property: " + ClassManager.manager.getSettings().getMoneyEnabled());
                    return;
                }
                if (!ClassManager.manager.getVaultHandler().getEconomy().hasAccount(p.getName())) {
                    ClassManager.manager.getMessageHandler().sendMessage("Economy.NoAccount", (CommandSender)p);
                    ClassManager.manager.getBugFinder().severe("Unable to give " + p.getName() + " his/her money: He/She does not have an economy account.");
                    return;
                }
                ClassManager.manager.getVaultHandler().getEconomy().depositPlayer(p.getName(), reward);
                return;
            }
            case 2: {
                ClassManager.manager.getPointsManager().givePoints((OfflinePlayer)p, reward);
            }
        }
    }

    public static String getDisplayPrice(GenesisCurrency currency, double price) {
        switch (currency.ordinal()) {
            case 1: {
                return ClassManager.manager.getMessageHandler().get("Display.Exp").replace("%levels%", MathTools.displayNumber((double)((int)price), currency.getPriceType()));
            }
            case 0: {
                return ClassManager.manager.getMessageHandler().get("Display.Money").replace("%money%", MathTools.displayNumber(price, currency.getPriceType()));
            }
            case 2: {
                return ClassManager.manager.getMessageHandler().get("Display.Points").replace("%points%", MathTools.displayNumber(price, currency.getPriceType()));
            }
        }
        return null;
    }

    public static enum GenesisCurrency {
        MONEY{

            @Override
            public GenesisPriceType getPriceType() {
                return GenesisPriceType.Money;
            }

            @Override
            public GenesisRewardType getRewardType() {
                return GenesisRewardType.Money;
            }

            @Override
            public double getBalance(Player p) {
                if (!ClassManager.manager.getVaultHandler().getEconomy().hasAccount(p.getName())) {
                    ClassManager.manager.getBugFinder().severe("Unable to read balance! No economy account existing! (" + p.getName() + ")");
                    return -1.0;
                }
                return ClassManager.manager.getVaultHandler().getEconomy().getBalance(p.getName());
            }
        }
        ,
        EXP{

            @Override
            public GenesisPriceType getPriceType() {
                return GenesisPriceType.Exp;
            }

            @Override
            public GenesisRewardType getRewardType() {
                return GenesisRewardType.Exp;
            }

            @Override
            public double getBalance(Player p) {
                return p.getExpToLevel();
            }
        }
        ,
        POINTS{

            @Override
            public GenesisPriceType getPriceType() {
                return GenesisPriceType.Points;
            }

            @Override
            public GenesisRewardType getRewardType() {
                return GenesisRewardType.Points;
            }

            @Override
            public double getBalance(Player p) {
                return ClassManager.manager.getPointsManager().getPoints((OfflinePlayer)p);
            }
        };


        public static GenesisCurrency detectCurrency(String name) {
            for (GenesisCurrency currency : GenesisCurrency.values()) {
                if (!currency.name().equalsIgnoreCase(name)) continue;
                return currency;
            }
            return null;
        }

        public abstract GenesisPriceType getPriceType();

        public abstract GenesisRewardType getRewardType();

        public abstract double getBalance(Player var1);
    }
}

