/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.serverpinging;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.misc.StringManipulationLib;
import studio.magemonkey.genesis.managers.serverpinging.ConnectedBuyItem;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector1;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector2;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector3;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector4;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnectorSmart;
import studio.magemonkey.genesis.managers.serverpinging.ServerInfo;
import studio.magemonkey.genesis.managers.serverpinging.ServerPingingList;
import studio.magemonkey.genesis.managers.serverpinging.ServerPingingRunnableHandler;

public class ServerPingingManager {
    private final String[] placeholderNames = new String[]{"players", "motd"};
    private final ServerPingingList list = new ServerPingingList();
    private ServerConnectorSmart connector;
    private boolean readyToTransform;
    private final ServerPingingRunnableHandler runnableHandler = new ServerPingingRunnableHandler();

    public ServerPingingManager(Genesis plugin) {
        Genesis.log("[ServerPinging] Loading ServerPinging Package!");
        int connectorType = plugin.getClassManager().getStorageManager().getConfig().getInt("serverpinging.connector");
        this.setup(plugin.getConfig().getStringList("ServerPinging.List"), connectorType);
    }

    public ServerPingingRunnableHandler getServerPingingRunnableHandler() {
        return this.runnableHandler;
    }

    public void setup(List<String> pingingList, int connectorType) {
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        try {
            connectors.add(new ServerConnector1());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            connectors.add(new ServerConnector2());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            connectors.add(new ServerConnector3());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            connectors.add(new ServerConnector4());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        this.connector = new ServerConnectorSmart(connectors);
        if (pingingList != null) {
            for (String connection : pingingList) {
                String[] parts = connection.split(":", 3);
                if (parts.length != 3 && parts.length != 2 && parts.length != 1) {
                    ClassManager.manager.getBugFinder().warn("Unable to read ServerPinging list entry '" + connection + "'. It should look like following: '<name>:<server ip>:<server port>' or if you are using BungeeCord then simply enter the name of the connected BungeeCord server: 'server name'.");
                    continue;
                }
                String name = parts[0].trim();
                if (parts.length == 1) {
                    ServerInfo info = new ServerInfo(name, ClassManager.manager.getSettings().getServerPingingTimeout());
                    this.list.addServerInfo(name, info);
                    continue;
                }
                String host = parts[1].trim();
                int port = 25565;
                if (parts.length == 3) {
                    try {
                        port = Integer.parseInt(parts[2].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ServerInfo info = new ServerInfo(host, port, ClassManager.manager.getSettings().getServerPingingTimeout());
                this.list.addServerInfo(name, info);
            }
        }
        this.list.update(this.connector, false);
    }

    public void update() {
        this.list.update(this.connector, true);
        if (ClassManager.manager.getShops() != null) {
            ClassManager.manager.getShops().refreshShops(true);
        }
    }

    public String transform(String s) {
        if (!this.readyToTransform) {
            return s;
        }
        if (StringManipulationLib.figureOutVariable(s, 0, this.placeholderNames) != null) {
            for (String placeholderName : this.placeholderNames) {
                int fromIndex = 0;
                String variable = StringManipulationLib.figureOutVariable(s, placeholderName, fromIndex);
                while (variable != null) {
                    s = this.transform(variable.split(":"), s, fromIndex);
                    fromIndex = StringManipulationLib.getIndexOfVariableEnd(s, placeholderName, fromIndex);
                    variable = StringManipulationLib.figureOutVariable(s, placeholderName, fromIndex);
                }
            }
        }
        return s;
    }

    public String transform(String[] servers, String current, int fromIndex) {
        if (!this.readyToTransform) {
            return current;
        }
        String motd = null;
        int players = 0;
        for (String serverName : servers) {
            ServerInfo c = this.getInfo(serverName);
            if (c == null || !c.isOnline()) continue;
            if (motd == null) {
                motd = c.getMotd();
            }
            players += c.getPlayers();
        }
        return this.transform(current, current, motd == null ? "unknown" : motd, String.valueOf(players), fromIndex);
    }

    public String transform(String serverName, String current, int fromIndex) {
        if (!this.readyToTransform) {
            return current;
        }
        ServerInfo c = this.getInfo(serverName);
        if (c != null && c.isOnline()) {
            String motd = c.getMotd();
            String players = String.valueOf(c.getPlayers());
            return this.transform(current, current, motd, players, fromIndex);
        }
        return current;
    }

    private String transform(String original, String current, String motd, String players, int fromIndex) {
        if (!this.readyToTransform) {
            return current;
        }
        boolean b = false;
        if (original.contains("%motd_") && motd != null) {
            original = StringManipulationLib.replacePlaceholder(original, "motd", motd, fromIndex);
            b = true;
        }
        if (original.contains("%players_") && players != null) {
            original = StringManipulationLib.replacePlaceholder(original, "players", players, fromIndex);
            b = true;
        }
        if (!b) {
            return current;
        }
        return original;
    }

    public void registerShopItem(String serverName, ConnectedBuyItem connection) {
        ServerInfo info = this.getInfo(serverName);
        if (info != null) {
            info.addShopItem(connection);
        }
    }

    public void clear() {
    }

    public ServerInfo getInfo(String serverName) {
        return this.list.getInfo(serverName);
    }

    public boolean containsServerpinging(GenesisShop shop) {
        for (GenesisBuy b : shop.getItems()) {
            if (b == null || !this.isConnected(b)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(GenesisBuy buy) {
        return this.getFirstInfo(buy) != null;
    }

    public ServerInfo getFirstInfo(GenesisBuy buy) {
        return this.list.getFirstInfo(buy);
    }

    @Generated
    public ServerPingingList getList() {
        return this.list;
    }

    @Generated
    public void setReadyToTransform(boolean readyToTransform) {
        this.readyToTransform = readyToTransform;
    }
}

