/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.serverpinging;

import java.net.InetSocketAddress;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.serverpinging.ConnectedBuyItem;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector;

public class ServerInfo {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_BUNGEECORD = 1;
    private final int type;
    private final String host;
    private final int port;
    private final int timeout;
    private final InetSocketAddress address;
    private int players;
    private int maxPlayers;
    private boolean online;
    private String motd;
    private long wait;
    private boolean beingPinged;
    private final Set<ConnectedBuyItem> buyitems = new LinkedHashSet<ConnectedBuyItem>();

    public ServerInfo(String host, int port, int timeout) {
        this.type = 0;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.address = new InetSocketAddress(host, port);
    }

    public ServerInfo(String bungeeCordServerName, int timeout) {
        this.type = 1;
        ClassManager.manager.getSettings().setBungeeCordServerEnabled(true);
        this.host = bungeeCordServerName;
        this.port = -1;
        this.address = null;
        this.motd = "unknown";
        this.timeout = timeout;
    }

    public void update(ServerConnector currentConnector) {
        switch (this.type) {
            case 0: {
                currentConnector.update(this);
                break;
            }
            case 1: {
                ClassManager.manager.getBungeeCordManager().sendPluginMessage(null, ClassManager.manager.getPlugin(), "PlayerCount", this.host);
            }
        }
    }

    public void setNoConnection() {
        this.online = false;
        this.players = 0;
        this.maxPlayers = 0;
        this.motd = "Offline";
    }

    public void hadNoSuccess() {
        int delay = ClassManager.manager.getSettings().getServerPingingWaitTime();
        if (delay > 0) {
            this.wait = System.currentTimeMillis() + (long)delay;
        }
    }

    public boolean isWaiting() {
        return this.wait > System.currentTimeMillis() || this.beingPinged;
    }

    public void addShopItem(ConnectedBuyItem shopItem) {
        this.buyitems.add(shopItem);
    }

    public Set<ConnectedBuyItem> getConnectedBuyItems() {
        return this.buyitems;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Generated
    public int getPlayers() {
        return this.players;
    }

    @Generated
    public void setPlayers(int players) {
        this.players = players;
    }

    @Generated
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Generated
    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    @Generated
    public boolean isOnline() {
        return this.online;
    }

    @Generated
    public void setOnline(boolean online) {
        this.online = online;
    }

    @Generated
    public String getMotd() {
        return this.motd;
    }

    @Generated
    public void setMotd(String motd) {
        this.motd = motd;
    }

    @Generated
    public void setBeingPinged(boolean beingPinged) {
        this.beingPinged = beingPinged;
    }
}

