/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.serverpinging;

import java.util.List;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.serverpinging.ServerConnector;
import studio.magemonkey.genesis.managers.serverpinging.ServerInfo;

public class ServerConnectorSmart
implements ServerConnector {
    private final List<ServerConnector> modules;
    private ServerConnector current;
    private int currentId = -1;
    private boolean hadSuccess;
    private int failsAmount;

    public ServerConnectorSmart(List<ServerConnector> modules) {
        this.modules = modules;
        this.hadSuccess = ClassManager.manager.getStorageManager().getConfig().contains("serverpinging.connector");
        int connectorType = ClassManager.manager.getStorageManager().getConfig().getInt("serverpinging.connector");
        if (connectorType >= 0 && connectorType < modules.size()) {
            this.currentId = connectorType;
            this.current = modules.get(this.currentId);
        } else {
            this.next();
        }
    }

    public void next() {
        if (this.modules != null) {
            ++this.currentId;
            if (this.modules.size() <= this.currentId) {
                this.currentId = 0;
            }
            this.current = this.modules.get(this.currentId);
        }
    }

    @Override
    public boolean update(ServerInfo info) {
        if (this.current != null) {
            if (info.isWaiting()) {
                return false;
            }
            info.setBeingPinged(true);
            if (this.current.update(info)) {
                if (!this.hadSuccess) {
                    ClassManager.manager.getStorageManager().getConfig().set("serverpinging.connector", (Object)this.currentId);
                    Genesis.log("Saving ServerPinging Connector '" + String.valueOf(this.current.getClass()) + "' to be instantly used next time.");
                    this.hadSuccess = true;
                    this.failsAmount = 0;
                }
                info.setBeingPinged(false);
                return true;
            }
            info.hadNoSuccess();
            ++this.failsAmount;
            boolean next = false;
            if (this.hadSuccess) {
                if (this.failsAmount > 50 & !ClassManager.manager.getSettings().getServerPingingFixConnector()) {
                    this.hadSuccess = false;
                    next = true;
                }
            } else if (this.failsAmount > 4) {
                next = true;
            }
            if (next) {
                ClassManager.manager.getBugFinder().warn("[ServerPinging] Connector '" + String.valueOf(this.current.getClass()) + "' does not seem to fit.. Trying an other Connector type.");
                this.failsAmount = 0;
                this.next();
            }
        }
        info.setBeingPinged(false);
        return false;
    }
}

