/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.events.GenesisCheckStringForFeaturesEvent;
import studio.magemonkey.genesis.events.GenesisTransformStringEvent;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.misc.StringManipulationLib;
import studio.magemonkey.genesis.managers.serverpinging.ConnectedBuyItem;
import studio.magemonkey.genesis.misc.MathTools;
import studio.magemonkey.genesis.misc.Misc;
import studio.magemonkey.genesis.misc.VersionManager;

public class StringManager {
    private static final Pattern hexPattern = Pattern.compile("(#[a-fA-F0-9]{6})");
    private static final Pattern placeholderPattern = Pattern.compile("%(.*?)%");

    public String transform(String s) {
        return this.transform(s, true);
    }

    public String transform(String s, boolean colorize) {
        if (s == null) {
            return null;
        }
        s = s.replace("[<3]", "\u2764").replace("[*]", "\u2605").replace("[**]", "\u2739").replace("[o]", "\u25cf").replace("[v]", "\u2714").replace("[+]", "\u2666").replace("[x]", "\u2726").replace("[%]", "\u2660").replace("[%%]", "\u2663").replace("[radioactive]", "\u2622").replace("[peace]", "\u262e").replace("[moon]", "\u263e").replace("[crown]", "\u2654").replace("[snowman]", "\u2603").replace("[tools]", "\u2692").replace("[swords]", "\u2694").replace("[note]", "\u2669 ").replace("[block]", "\u2588").replace("[triangle]", "\u25b2").replace("[warn]", "\u26a0").replace("[left]", "\u2190").replace("[right]", "\u2192").replace("[up]", "\u2191").replace("[down]", "\u2193");
        if (colorize) {
            s = this.colorize(s);
        }
        if (ClassManager.manager.getSettings().getServerPingingEnabled(true)) {
            s = ClassManager.manager.getServerPingingManager().transform(s);
        }
        s = MathTools.transform(s);
        s = s.replace("[and]", "&");
        s = s.replace("[colon]", ":");
        s = s.replace("[hashtag]", "#");
        return s;
    }

    private String colorize(String string) {
        if (VersionManager.isAtLeast(16)) {
            Matcher matcher = hexPattern.matcher(string);
            while (matcher.find()) {
                String color = matcher.group(1);
                string = string.replace(color, String.valueOf(net.md_5.bungee.api.ChatColor.of((String)color)));
                matcher = hexPattern.matcher(string);
            }
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public String transform(String s, GenesisBuy item, GenesisShop shop, GenesisShopHolder holder, Player target) {
        return this.transform(s, item, shop, holder, target, true);
    }

    public String transform(String s, GenesisBuy item, GenesisShop shop, GenesisShopHolder holder, Player target, boolean colorize) {
        if (s == null) {
            return null;
        }
        if (s.contains("%")) {
            if (item != null) {
                s = item.transformMessage(s, shop, target);
            }
            if (shop != null) {
                if (shop.getShopName() != null) {
                    s = s.replace("%shop%", shop.getShopName());
                }
                if (shop.getDisplayName() != null) {
                    s = s.replace("%shopdisplayname%", shop.getDisplayName());
                }
            }
            if (holder != null) {
                s = s.replace("%page%", String.valueOf(holder.getDisplayPage()));
                s = s.replace("%maxpage%", String.valueOf(holder.getDisplayHighestPage()));
            }
            GenesisTransformStringEvent event = new GenesisTransformStringEvent(s, item, shop, holder, target);
            Bukkit.getPluginManager().callEvent((Event)event);
            s = event.getText();
        }
        return this.transform(s, target, colorize);
    }

    public String transform(String s, Player target) {
        return this.transform(s, target, true);
    }

    public String transform(String s, Player target, boolean colorize) {
        if (s == null) {
            return null;
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher matcher = placeholderPattern.matcher(s);
        while (matcher.find()) {
            placeholders.add(matcher.group(1));
        }
        Iterator iterator = placeholders.iterator();
        while (iterator.hasNext()) {
            String placeholder;
            String replacement = placeholder = (String)iterator.next();
            if (placeholder.matches("\u00a7.*?")) {
                replacement = placeholder.replaceAll("^(\u00a7(x[0-9a-fA-F]{6}|\\w))+", "");
            }
            s = s.replace(placeholder, replacement);
        }
        if (target != null && s.contains("%")) {
            s = s.replace("%name%", target.getName()).replace("%player%", target.getName()).replace("%target%", target.getName());
            s = s.replace("%displayname%", target.getDisplayName());
            if ((s = s.replace("%uuid%", target.getUniqueId().toString())).contains("%balance%") && ClassManager.manager.getVaultHandler() != null && ClassManager.manager.getVaultHandler().getEconomy() != null) {
                double balance = ClassManager.manager.getVaultHandler().getEconomy().getBalance((OfflinePlayer)target);
                s = s.replace("%balance%", MathTools.displayNumber(balance, GenesisPriceType.Money));
            }
            if (s.contains("%balancepoints%") && ClassManager.manager.getPointsManager() != null) {
                double balancePoints = ClassManager.manager.getPointsManager().getPoints((OfflinePlayer)target);
                s = s.replace("%balancepoints%", MathTools.displayNumber(balancePoints, GenesisPriceType.Points));
            }
            if (s.contains("%world%")) {
                s = s.replace("%world%", target.getWorld().getName());
            }
            if (s.contains("%item_in_hand%")) {
                s = s.replace("%item_in_hand%", Misc.getItemInMainHand(target).getType().name());
            }
            if (s.contains("%input%")) {
                s = s.replace("%input%", ClassManager.manager.getPlayerDataHandler().getInput(target));
            }
            if (ClassManager.manager.getPlaceholderHandler() != null) {
                s = ClassManager.manager.getPlaceholderHandler().transformString(s, target);
            }
        }
        return this.transform(s, colorize);
    }

    public boolean checkStringForFeatures(GenesisShop shop, GenesisBuy buy, ItemStack menuItem, @NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        boolean b = s.matches(hexPattern.pattern());
        if (s.contains("%")) {
            String serverNames;
            if (s.contains("%balance%")) {
                ClassManager.manager.getSettings().setBalanceVariableEnabled(true);
                ClassManager.manager.getSettings().setVaultEnabled(true);
                ClassManager.manager.getSettings().setMoneyEnabled(true);
                b = true;
            }
            if (s.contains("%balancepoints%")) {
                ClassManager.manager.getSettings().setBalancePointsVariableEnabled(true);
                ClassManager.manager.getSettings().setPointsEnabled(true);
                b = true;
            }
            if (s.contains("%name%") || s.contains("%player%") || s.contains("%uuid%")) {
                b = true;
            }
            if (s.contains("%page%") || s.contains("%maxpage%")) {
                b = true;
            }
            if (s.contains("%world%")) {
                b = true;
            }
            if (buy != null && shop != null && ClassManager.manager.getSettings().getServerPingingEnabled(true) && (serverNames = StringManipulationLib.figureOutVariable(s, 0, "players", "motd")) != null) {
                b = true;
                if (buy.getItem() != null) {
                    String[] servers = serverNames.split(":");
                    ClassManager.manager.getServerPingingManager().registerShopItem(servers[0].trim(), new ConnectedBuyItem(buy, menuItem));
                }
            }
            if (s.contains("%reward%") || s.contains("%price%")) {
                if (ClassManager.manager.getMultiplierHandler().hasMultipliers()) {
                    b = true;
                }
                if (buy.getPriceType(null) == GenesisPriceType.ItemAll || buy.getRewardType(null) == GenesisRewardType.ItemAll) {
                    b = true;
                }
            }
            if (s.contains("%input%")) {
                b = true;
            }
            if (ClassManager.manager.getPlaceholderHandler() != null && ClassManager.manager.getPlaceholderHandler().containsPlaceholder(s)) {
                b = true;
            }
            GenesisCheckStringForFeaturesEvent event = new GenesisCheckStringForFeaturesEvent(s, buy, shop);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.containsFeature()) {
                b = true;
            }
        }
        if (s.contains("{") && s.contains("}")) {
            b = true;
        }
        return b;
    }
}

