/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.misc;

import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.misc.Enchant;
import studio.magemonkey.genesis.misc.MathTools;

public class InputReader {
    public static String readString(Object o, boolean lowercase) {
        if (o == null) {
            return null;
        }
        String s = String.valueOf(o);
        if (s != null && lowercase) {
            s = s.toLowerCase();
        }
        return s;
    }

    public static List<String> readStringList(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)o);
            return list;
        }
        return null;
    }

    public static List<List<String>> readStringListList(Object o) {
        if (!(o instanceof List)) {
            return null;
        }
        List list = (List)o;
        if (list.isEmpty()) {
            return null;
        }
        if (list.get(0) instanceof List) {
            return (List)o;
        }
        ArrayList<List<String>> main = new ArrayList<List<String>>();
        main.add((List)o);
        return main;
    }

    public static List<ItemStack> readItemList(Object o, boolean finalVersion) {
        List<List<String>> list = InputReader.readStringListList(o);
        if (list != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (List<String> s : list) {
                items.add(ClassManager.manager.getItemStackCreator().createItemStack(s, finalVersion));
            }
            return items;
        }
        return null;
    }

    public static ItemStack readItem(Object o, boolean finalVersion) {
        List<ItemStack> list = InputReader.readItemList(o, finalVersion);
        if (list != null & !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static Enchant readEnchant(Object o) {
        String[] parts;
        String s = InputReader.readString(o, false);
        if (s != null && (parts = s.split("#", 2)).length == 2) {
            int lvl;
            String pName = parts[0].trim();
            String pLevel = parts[1].trim();
            try {
                lvl = Integer.parseInt(pLevel);
            }
            catch (NumberFormatException ex) {
                ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + pLevel + "' is not a valid enchantment level.");
                return null;
            }
            Enchantment e = InputReader.readEnchantment(pName);
            if (e == null) {
                ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + pName + "' is not a valid enchantment name/id.");
                return null;
            }
            return new Enchant(e, lvl);
        }
        return null;
    }

    public static Enchantment readEnchantment(String name) {
        if (name != null) {
            return EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase()));
        }
        return null;
    }

    public static boolean getBoolean(String s, boolean def) {
        if (s != null) {
            if (s.equalsIgnoreCase(Boolean.TRUE.toString()) || s.equalsIgnoreCase("yes")) {
                return true;
            }
            if (s.equalsIgnoreCase(Boolean.FALSE.toString()) || s.equalsIgnoreCase("no")) {
                return false;
            }
        }
        return def;
    }

    public static double getDouble(Object o, double exception) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return MathTools.calculate(s, exception);
            }
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        return exception;
    }

    public static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getInt(Object o, int exception) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return (int)InputReader.getDouble(s, exception);
            }
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            double d = (Double)o;
            return (int)d;
        }
        return exception;
    }

    public static HashMap<Integer, String> readTimedCommands(Object o) {
        List<String> list = InputReader.readStringList(o);
        if (list != null) {
            HashMap<Integer, String> cmds = new HashMap<Integer, String>();
            for (String s : list) {
                try {
                    String[] parts = s.split(":", 2);
                    String a1 = parts[0].trim();
                    int i = Integer.parseInt(a1);
                    String cmd = parts[1].trim();
                    cmds.put(i, cmd);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return cmds;
        }
        return null;
    }

    public static Material readMaterial(String s) {
        Material m = Material.matchMaterial((String)s, (boolean)false);
        if (m == null) {
            m = Material.matchMaterial((String)s, (boolean)true);
        }
        return m;
    }

    public static EntityType readEntityType(String s) {
        for (EntityType e : EntityType.values()) {
            if (!e.name().replace("_", "").equalsIgnoreCase(s.replace("_", ""))) continue;
            return e;
        }
        return null;
    }

    @Nullable
    public static BaseComponent readChatComponent(String rawJson) {
        try {
            BaseComponent[] array = ComponentSerializer.parse((String)rawJson);
            if (array.length == 0) {
                return new TextComponent();
            }
            if (array.length == 1) {
                return array[0];
            }
            TextComponent component = new TextComponent();
            for (BaseComponent baseComponent : array) {
                component.addExtra(baseComponent);
            }
            return component;
        }
        catch (JsonParseException e) {
            return null;
        }
    }
}

