/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPartCustomSkull;
import studio.magemonkey.genesis.managers.misc.StringManager;

public class ItemStackTranslator {
    public ItemStack translateItemStack(GenesisBuy buy, GenesisShop shop, GenesisShopHolder holder, ItemStack item, Player target, boolean finalVersion) {
        if (item != null && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName()) {
                meta.setDisplayName(ClassManager.manager.getStringManager().transform(meta.getDisplayName(), buy, shop, holder, target));
            }
            if (meta.hasLore()) {
                List lore = meta.getLore();
                for (int i = 0; i < lore.size(); ++i) {
                    lore.set(i, ClassManager.manager.getStringManager().transform((String)lore.get(i), buy, shop, holder, target));
                }
                meta.setLore(this.splitLore(lore, ClassManager.manager.getSettings().getMaxLineLength(), finalVersion));
            }
            if (meta instanceof SkullMeta) {
                String placeholder;
                SkullMeta skullmeta = (SkullMeta)meta;
                NamespacedKey key = new NamespacedKey((Plugin)ClassManager.manager.getPlugin(), "skullOwnerPlaceholder");
                CustomItemTagContainer tagContainer = meta.getCustomTagContainer();
                if (tagContainer.hasCustomTag(key, ItemTagType.STRING) && (placeholder = (String)tagContainer.getCustomTag(key, ItemTagType.STRING)) != null) {
                    String pName = ClassManager.manager.getStringManager().transform(placeholder, target);
                    if (!ClassManager.manager.getStringManager().checkStringForFeatures(shop, buy, item, pName)) {
                        OfflinePlayer transformedPlayer = Bukkit.getOfflinePlayer((String)pName);
                        if (transformedPlayer != null) {
                            skullmeta.setOwningPlayer(transformedPlayer);
                        } else {
                            skullmeta.setOwner(pName);
                        }
                    }
                }
            }
            item.setItemMeta(meta);
            if (meta instanceof SkullMeta) {
                this.transformCustomSkull(buy, shop, item, holder, target);
            }
        }
        return item;
    }

    private void transformCustomSkull(GenesisBuy buy, GenesisShop shop, ItemStack item, GenesisShopHolder holder, Player target) {
        String placeholder;
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)ClassManager.manager.getPlugin(), "skullTexturePlaceholder");
        CustomItemTagContainer tagContainer = meta.getCustomTagContainer();
        if (tagContainer.hasCustomTag(key, ItemTagType.STRING) && (placeholder = (String)tagContainer.getCustomTag(key, ItemTagType.STRING)) != null) {
            String texture = ClassManager.manager.getStringManager().transform(placeholder, target);
            if (!ClassManager.manager.getStringManager().checkStringForFeatures(shop, buy, item, texture)) {
                ItemDataPartCustomSkull.transformSkull(item, texture);
            }
        }
    }

    private List<String> splitLore(List<String> lore, int maxLineLength, boolean finalVersion) {
        if (maxLineLength > 0 && finalVersion) {
            ArrayList<String> goal = new ArrayList<String>();
            for (String line : lore) {
                String[] words = line.split(" ");
                Object current = null;
                for (String word : words) {
                    if (current == null) {
                        current = word;
                        continue;
                    }
                    String next = (String)current + " " + word;
                    if (ChatColor.stripColor((String)next).length() > maxLineLength) {
                        goal.add((String)current);
                        String lastColors = current == null ? "" : ChatColor.getLastColors((String)current);
                        current = lastColors + word;
                        continue;
                    }
                    current = next;
                }
                goal.add((String)current);
            }
            return goal;
        }
        return lore;
    }

    public String getFriendlyText(List<ItemStack> items) {
        if (items != null) {
            Object msg = "";
            int x = 0;
            for (ItemStack i : items) {
                msg = (String)msg + this.readItemStack(i) + (++x < items.size() ? ", " : "");
            }
            return msg;
        }
        return null;
    }

    public String readItemStack(ItemStack i) {
        if (ClassManager.manager.getLanguageManager() != null) {
            return i.getAmount() + " " + ClassManager.manager.getLanguageManager().getDisplayNameItem(i);
        }
        String material = this.readMaterial(i);
        return i.getAmount() + " " + material;
    }

    public String readEnchantment(Enchantment e) {
        if (ClassManager.manager.getLanguageManager() != null) {
            return ClassManager.manager.getLanguageManager().getDisplayNameEnchantment(e);
        }
        return e.getName().toLowerCase().replace("_", "");
    }

    public boolean checkItemStackForFeatures(GenesisShop shop, GenesisBuy buy, ItemStack item) {
        boolean b = false;
        if (item != null && item.hasItemMeta()) {
            SkullMeta skullmeta;
            StringManager s = ClassManager.manager.getStringManager();
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName() && s.checkStringForFeatures(shop, buy, item, meta.getDisplayName())) {
                b = true;
            }
            if (meta.hasLore()) {
                List lore = meta.getLore();
                for (String string : lore) {
                    if (!s.checkStringForFeatures(shop, buy, item, string)) continue;
                    b = true;
                }
            }
            if (meta instanceof SkullMeta && (skullmeta = (SkullMeta)meta).hasOwner() && skullmeta.getOwnerProfile() != null && skullmeta.getOwnerProfile().getName() != null && s.checkStringForFeatures(shop, buy, item, skullmeta.getOwnerProfile().getName())) {
                b = true;
            }
        }
        return b;
    }

    public String readItemName(ItemStack item) {
        if (item != null) {
            ItemMeta meta;
            if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName()) {
                return meta.getDisplayName();
            }
            return this.readItemStack(item);
        }
        return null;
    }

    public String readMaterial(ItemStack item) {
        if (ClassManager.manager.getLanguageManager() != null) {
            ItemStack i = new ItemStack(item.getType());
            return ClassManager.manager.getLanguageManager().getDisplayNameItem(i);
        }
        String material = item.getType().name().toLowerCase().replace("_", " ");
        material = material.replaceFirst(material.substring(0, 1), material.substring(0, 1).toUpperCase());
        return material;
    }

    public void copyTexts(ItemStack receiver, ItemStack source) {
        if (source.hasItemMeta()) {
            ItemMeta metaSource = source.getItemMeta();
            ItemMeta metaReceiver = receiver.getItemMeta();
            if (metaSource.hasDisplayName()) {
                metaReceiver.setDisplayName(metaSource.getDisplayName());
            }
            if (metaSource.hasLore()) {
                metaReceiver.setLore(metaSource.getLore());
            }
            if (metaSource instanceof SkullMeta && metaReceiver instanceof SkullMeta) {
                SkullMeta skullMetaSource = (SkullMeta)metaSource;
                SkullMeta skullMetaReceiver = (SkullMeta)metaReceiver;
                if (skullMetaSource.hasOwner()) {
                    skullMetaReceiver.setOwner(skullMetaSource.getOwner());
                }
            }
            receiver.setItemMeta(metaReceiver);
        }
    }

    public boolean isItemList(Object o) {
        if (o instanceof List) {
            return this.isItemList((List)o);
        }
        return false;
    }

    public boolean isItemList(List<?> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        Object first = list.get(0);
        return first instanceof ItemStack;
    }
}

