/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.GenesisConfigShop;
import studio.magemonkey.genesis.managers.item.ItemDataPart;
import studio.magemonkey.genesis.managers.misc.InputReader;
import studio.magemonkey.genesis.managers.misc.StringManipulationLib;
import studio.magemonkey.genesis.misc.Misc;

public class ItemStackCreator {
    public ItemStack createItemStack(List<String> itemData, GenesisBuy buy, GenesisShop shop, boolean finalVersion) {
        if (shop instanceof GenesisConfigShop) {
            GenesisConfigShop cShop = (GenesisConfigShop)shop;
            List<String> newList = null;
            for (String line : itemData) {
                String priceLine;
                String rewardLine = StringManipulationLib.figureOutVariable(line, "rewarditem", 0);
                if (rewardLine != null) {
                    if (newList == null) {
                        newList = this.cloneList(itemData);
                    }
                    int i = InputReader.getInt(rewardLine, -1) - 1;
                    newList = this.transform(line, i, newList, buy, cShop, "Reward");
                }
                if ((priceLine = StringManipulationLib.figureOutVariable(line, "priceitem", 0)) != null) {
                    if (newList == null) {
                        newList = this.cloneList(itemData);
                    }
                    int i = InputReader.getInt(rewardLine, -1) - 1;
                    newList = this.transform(line, i, newList, buy, cShop, "Price");
                }
                if (newList == null) continue;
                return this.createItemStack(newList, finalVersion);
            }
        }
        return this.createItemStack(itemData, finalVersion);
    }

    private List<String> transform(String line, int index, List<String> newList, GenesisBuy buy, GenesisConfigShop shop, String path) {
        if (index != -1) {
            newList.remove(line);
            List<List<String>> list = InputReader.readStringListList(buy.getConfigurationSection(shop).get(path));
            if (list != null) {
                if (list.size() > index) {
                    for (String entry : list.get(index)) {
                        newList.add(entry);
                    }
                } else {
                    ClassManager.manager.getBugFinder().warn("Was trying to import the item look for MenuItem of shopitem '" + buy.getName() + "' in shop '" + shop.getShopName() + "' but your " + path + " does not contain a " + index + ". item!");
                }
            } else {
                ClassManager.manager.getBugFinder().warn("Was trying to import the item look for MenuItem of shopitem '" + buy.getName() + "' in shop '" + shop.getShopName() + "' but your " + path + " is not an item list!");
            }
        }
        return newList;
    }

    private List<String> cloneList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<String> clone = new ArrayList<String>(list);
        return clone;
    }

    public ItemStack createItemStack(List<String> itemData, boolean finalVersion) {
        ItemStack i = new ItemStack(Material.STONE);
        itemData = Misc.fixLore(itemData);
        i = ItemDataPart.transformItem(i, itemData);
        ClassManager.manager.getItemStackTranslator().translateItemStack(null, null, null, i, null, finalVersion);
        return i;
    }

    public void giveItem(Player p, GenesisBuy buy, ItemStack i, boolean cloneItem) {
        this.giveItem(p, buy, i, i.getAmount(), cloneItem);
    }

    public void giveItem(Player p, GenesisBuy buy, ItemStack i, int amount, boolean cloneItem) {
        if (cloneItem) {
            i = i.clone();
        }
        int stackSize = ClassManager.manager.getItemStackChecker().getMaxStackSize(i);
        i = ClassManager.manager.getItemStackTranslator().translateItemStack(buy, null, null, cloneItem ? i.clone() : i, p, true);
        for (int toGive = amount; toGive > 0; toGive -= i.getAmount()) {
            i.setAmount(Math.min(stackSize, toGive));
            this.giveItem(p, i.clone(), stackSize);
        }
    }

    private void giveItem(Player p, ItemStack i, int stackSize) {
        if (i.getAmount() > stackSize) {
            throw new RuntimeException("Can not give an itemstack with a higher amount than the maximum stack size at once to a player.");
        }
        int free = ClassManager.manager.getItemStackChecker().getAmountOfFreeSpace(p, i);
        if (free < i.getAmount()) {
            this.dropItem(p, i, stackSize);
        } else {
            p.getInventory().addItem(new ItemStack[]{i});
        }
    }

    private void dropItem(Player p, ItemStack i, int stackSize) {
        int toTake = i.getAmount();
        i = i.clone();
        while (toTake > 0) {
            int amount = Math.min(toTake, stackSize);
            i.setAmount(amount);
            p.getWorld().dropItem(p.getLocation(), i);
            toTake -= amount;
        }
    }
}

