/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPart;

public class ItemStackChecker {
    public static final int INVENTORY_SLOT_START = 0;
    public static final int INVENTORY_SLOT_END = 35;
    private final List<String> toolSuffixes = new ArrayList<String>();
    private final List<Material> toolsComplete;

    public ItemStackChecker() {
        this.toolSuffixes.add("AXE");
        this.toolSuffixes.add("HOE");
        this.toolSuffixes.add("PICKAXE");
        this.toolSuffixes.add("SPADE");
        this.toolSuffixes.add("SWORD");
        this.toolSuffixes.add("BOOTS");
        this.toolSuffixes.add("CHESTPLATE");
        this.toolSuffixes.add("HELMET");
        this.toolSuffixes.add("LEGGINGS");
        this.toolSuffixes.add("BARDING");
        this.toolsComplete = new ArrayList<Material>();
        this.toolsComplete.add(Material.BOW);
        this.toolsComplete.add(Material.FLINT_AND_STEEL);
        this.toolsComplete.add(Material.SHEARS);
        this.toolsComplete.add(Material.FISHING_ROD);
    }

    public boolean inventoryContainsItem(Player p, ItemStack i, GenesisBuy buy) {
        return this.getAmountOfSameItems(p, i, buy) >= i.getAmount();
    }

    public void takeItem(ItemStack shopItem, Player p, GenesisBuy buy) {
        int a = 0;
        int slot = -1;
        for (ItemStack playerItem : p.getInventory().getContents()) {
            if (playerItem == null || playerItem.getType() == Material.AIR || !this.canSell(p, playerItem, shopItem, ++slot, buy)) continue;
            playerItem = playerItem.clone();
            playerItem.setAmount(Math.min(playerItem.getAmount(), shopItem.getAmount() - a));
            p.getInventory().removeItem(new ItemStack[]{playerItem});
            if ((a += playerItem.getAmount()) >= shopItem.getAmount()) break;
        }
        if ((a -= shopItem.getAmount()) > 0) {
            ClassManager.manager.getBugFinder().warn("Player " + p.getName() + " lost " + a + " items of type " + shopItem.getType().name() + ". How would that happen?");
        }
    }

    public int getAmountOfSameItems(Player p, ItemStack shopItem, GenesisBuy buy) {
        int a = 0;
        int slot = -1;
        for (ItemStack playerItem : p.getInventory().getContents()) {
            if (playerItem == null || !this.canSell(p, playerItem, shopItem, ++slot, buy)) continue;
            a += playerItem.getAmount();
        }
        return a;
    }

    public boolean hasFreeSpace(Player p, ItemStack item) {
        return this.getAmountOfFreeSpace(p, item) >= item.getAmount();
    }

    public int getAmountOfFreeSpace(Player p, ItemStack item) {
        int freeSlots = 0;
        for (int slot = 0; slot <= 35; ++slot) {
            ItemStack slotItem = p.getInventory().getItem(slot);
            if (slotItem == null || slotItem.getType() == Material.AIR) {
                freeSlots += item.getMaxStackSize();
                continue;
            }
            if (!slotItem.isSimilar(item)) continue;
            freeSlots += Math.max(0, slotItem.getMaxStackSize() - slotItem.getAmount());
        }
        return freeSlots;
    }

    public boolean hasFreeSpace(Player p, List<ItemStack> items) {
        ItemStack slotItem;
        int slot;
        HashMap<ItemStack, Integer> amounts = new HashMap<ItemStack, Integer>();
        for (ItemStack item : items) {
            int amount = item.getAmount();
            if (amounts.containsKey(item)) {
                amount += ((Integer)amounts.get(item)).intValue();
            }
            amounts.put(item, amount);
        }
        block1: for (slot = 0; slot <= 35; ++slot) {
            slotItem = p.getInventory().getItem(slot);
            if (slotItem == null) continue;
            for (ItemStack item : amounts.keySet()) {
                if (!slotItem.isSimilar(item)) continue;
                int spaceLeft = slotItem.getMaxStackSize() - slotItem.getAmount();
                int amountLeft = Math.max(0, (Integer)amounts.get(item) - spaceLeft);
                if (amountLeft == 0) {
                    amounts.remove(item);
                    continue block1;
                }
                amounts.put(item, amountLeft);
                continue block1;
            }
        }
        block3: for (slot = 0; slot <= 35; ++slot) {
            slotItem = p.getInventory().getItem(slot);
            if (slotItem != null) continue;
            for (ItemStack item : amounts.keySet()) {
                int amountLeft = (Integer)amounts.get(item);
                if (amountLeft <= 0) continue;
                if ((amountLeft = Math.max(0, amountLeft - item.getMaxStackSize())) == 0) {
                    amounts.remove(item);
                    continue block3;
                }
                amounts.put(item, amountLeft);
                continue block3;
            }
        }
        return amounts.isEmpty();
    }

    private boolean canSell(Player p, ItemStack playerItem, ItemStack shopItem, int slot, GenesisBuy buy) {
        if (slot < 0 || slot > 35) {
            return false;
        }
        ItemDataPart exceptionDurability = this.isTool(playerItem) && ClassManager.manager.getSettings().getAllowSellingDamagedItems() ? ItemDataPart.DURABILITY : null;
        ItemDataPart[] exceptions = new ItemDataPart[]{exceptionDurability};
        return ItemDataPart.isSimilar(shopItem, playerItem, exceptions, buy, false, p);
    }

    public boolean isEqualShopItemAdvanced(ItemStack a, ItemStack b, boolean compareText, Player p) {
        return this.isEqualShopItemAdvanced(a, b, compareText, true, true, p);
    }

    public boolean isEqualShopItemAdvanced(ItemStack a, ItemStack b, boolean compareText, boolean compareAmount, boolean compareItemMetaExistence, Player p) {
        if (a != null && b != null) {
            if (compareItemMetaExistence && a.hasItemMeta() != b.hasItemMeta()) {
                return false;
            }
            ItemDataPart exceptionDurability = this.isTool(a) && ClassManager.manager.getSettings().getAllowSellingDamagedItems() ? ItemDataPart.DURABILITY : null;
            ItemDataPart[] exceptions = !compareText ? new ItemDataPart[]{exceptionDurability, ItemDataPart.NAME, ItemDataPart.LORE, ItemDataPart.PLAYERHEAD} : new ItemDataPart[]{exceptionDurability};
            return ItemDataPart.isSimilar(a, b, exceptions, null, compareAmount, p);
        }
        return false;
    }

    public boolean isTool(ItemStack i) {
        if (this.toolsComplete.contains(i.getType())) {
            return true;
        }
        for (String toolSuffix : this.toolSuffixes) {
            if (!i.getType().name().endsWith(toolSuffix)) continue;
            return true;
        }
        return false;
    }

    public int getMaxStackSize(ItemStack i) {
        if (ClassManager.manager.getSettings().getCheckStackSize()) {
            return i.getMaxStackSize();
        }
        return 64;
    }
}

