/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPart;

public class ItemDataPartLore
extends ItemDataPart {
    @Override
    public ItemStack transform(ItemStack item, String usedName, String argument) {
        ItemMeta meta = item.getItemMeta();
        String argumentTransformed = ClassManager.manager.getStringManager().transform(argument);
        String[] parts = argumentTransformed.split("[#\\n]");
        ArrayList lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList();
        }
        Collections.addAll(lore, parts);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public int getPriority() {
        return PRIORITY_NORMAL;
    }

    @Override
    public boolean removeSpaces() {
        return false;
    }

    @Override
    public String[] createNames() {
        return new String[]{"lore", "description"};
    }

    @Override
    public List<String> read(ItemStack i, List<String> output) {
        if (i.getItemMeta().hasLore()) {
            int a = 1;
            for (String line : i.getItemMeta().getLore()) {
                output.add("lore" + a + ":" + line.replaceAll(String.valueOf('\u00a7'), "&"));
                ++a;
            }
        }
        return output;
    }

    @Override
    public boolean isSimilar(ItemStack shopItem, ItemStack playerItem, GenesisBuy buy, Player p) {
        ItemMeta shopMeta = shopItem.getItemMeta();
        ItemMeta playerMeta = playerItem.getItemMeta();
        if (shopMeta.hasLore()) {
            if (!playerMeta.hasLore()) {
                return false;
            }
            if (shopMeta.getLore().size() > playerMeta.getLore().size()) {
                return false;
            }
            for (int i = 0; i < shopMeta.getLore().size(); ++i) {
                String shopItemLoreLine = (String)shopMeta.getLore().get(i);
                if (ClassManager.manager.getStringManager().checkStringForFeatures(buy == null ? null : buy.getShop(), buy, buy == null ? null : buy.getItem(), shopItemLoreLine)) {
                    shopItemLoreLine = ClassManager.manager.getStringManager().transform(shopItemLoreLine, buy, buy == null ? null : buy.getShop(), null, p);
                }
                if (((String)playerMeta.getLore().get(i)).equals(shopItemLoreLine)) continue;
                return false;
            }
        }
        return true;
    }
}

