/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPart;
import studio.magemonkey.genesis.managers.misc.InputReader;

public class ItemDataPartDurability
extends ItemDataPart {
    @Override
    public ItemStack transform(ItemStack item, String usedName, String argument) {
        int damage = InputReader.getInt(argument, -1);
        if (damage == -1) {
            ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + argument + "' is not a valid '" + usedName + "'. It needs to be an integer number like '0', '5' or '200'. ");
            return item;
        }
        if (!(item.getItemMeta() instanceof Damageable)) {
            ClassManager.manager.getBugFinder().severe("Mistake in Config: Unable to add damage/durability to items of type '" + String.valueOf(item.getType()) + "'.");
            return item;
        }
        Damageable d = (Damageable)item.getItemMeta();
        d.setDamage(damage);
        item.setItemMeta((ItemMeta)d);
        return item;
    }

    @Override
    public int getPriority() {
        return PRIORITY_EARLY;
    }

    @Override
    public boolean removeSpaces() {
        return true;
    }

    @Override
    public String[] createNames() {
        return new String[]{"damage", "durability", "subid"};
    }

    @Override
    public List<String> read(ItemStack i, List<String> output) {
        if (i.hasItemMeta() && i.getItemMeta() instanceof Damageable) {
            Damageable d = (Damageable)i.getItemMeta();
            output.add("durability:" + d.getDamage());
        }
        return output;
    }

    @Override
    public boolean isSimilar(ItemStack shopItem, ItemStack playerItem, GenesisBuy buy, Player p) {
        if (shopItem.getItemMeta() instanceof Damageable != playerItem.getItemMeta() instanceof Damageable) {
            return false;
        }
        if (shopItem.getItemMeta() instanceof Damageable) {
            Damageable a = (Damageable)shopItem.getItemMeta();
            Damageable b = (Damageable)playerItem.getItemMeta();
            return a.getDamage() == b.getDamage();
        }
        return true;
    }
}

