/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPart;

public class ItemDataPartCustomSkull
extends ItemDataPart {
    public static ItemStack transformSkull(ItemStack i, String input) {
        if (input == null || input.isEmpty()) {
            return i;
        }
        SkullMeta skullMeta = (SkullMeta)i.getItemMeta();
        if (skullMeta == null) {
            return i;
        }
        if (ClassManager.manager.getStringManager().checkStringForFeatures(null, null, null, input)) {
            NamespacedKey key = new NamespacedKey((Plugin)ClassManager.manager.getPlugin(), "skullTexturePlaceholder");
            skullMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)input);
        } else {
            UUID id = UUID.randomUUID();
            if (input.contains("http://textures.minecraft.net/texture") || input.contains("https://textures.minecraft.net/texture")) {
                try {
                    PlayerProfile pprofile = Bukkit.createPlayerProfile((UUID)id, (String)id.toString().replace("-", "").substring(0, 16));
                    pprofile.getTextures().setSkin(new URL(input));
                    skullMeta.setOwnerProfile(pprofile);
                    i.setItemMeta((ItemMeta)skullMeta);
                    return i;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Could not convert url to texture: " + input, e);
                }
            }
            try {
                PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)id, (String)id.toString().replace("-", "").substring(0, 16));
                String decoded = new String(Base64.getDecoder().decode(input));
                JsonObject json = (JsonObject)new Gson().fromJson(decoded, JsonObject.class);
                JsonObject texturesJson = json.getAsJsonObject("textures");
                JsonObject skin = texturesJson.getAsJsonObject("SKIN");
                String url = skin.get("url").getAsString();
                playerProfile.getTextures().setSkin(new URL(url));
                skullMeta.setOwnerProfile(playerProfile);
            }
            catch (IllegalArgumentException | NoClassDefFoundError | NoSuchMethodError | MalformedURLException e) {
                try {
                    String cleaned = id.toString().replace("-", "");
                    GameProfile profile = new GameProfile(id, cleaned.substring(0, Math.min(cleaned.length(), 16)));
                    profile.getProperties().put((Object)"textures", (Object)ItemDataPartCustomSkull.getProperty(input));
                    Field profileField = skullMeta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(skullMeta, profile);
                }
                catch (IllegalAccessException | NoSuchFieldException | SecurityException e1) {
                    ClassManager.manager.getBugFinder().warn("Could not set profile texture: " + input);
                    e1.printStackTrace();
                }
            }
        }
        i.setItemMeta((ItemMeta)skullMeta);
        return i;
    }

    private static Property getProperty(String texture) {
        return new Property("textures", texture);
    }

    public static String readSkullTexture(ItemStack i) {
        if (i.getType() == Material.PLAYER_HEAD) {
            SkullMeta meta = (SkullMeta)i.getItemMeta();
            if (meta == null) {
                return null;
            }
            try {
                PlayerProfile profile = meta.getOwnerProfile();
                if (profile == null) {
                    return null;
                }
                if (profile.getTextures().getSkin() == null) {
                    return null;
                }
                return profile.getTextures().getSkin().toString();
            }
            catch (Exception | NoSuchMethodError ex) {
                try {
                    Iterator iterator;
                    Collection properties;
                    Field profileField = meta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    GameProfile profile = (GameProfile)profileField.get(meta);
                    if (profile != null && profile.getProperties() != null && (properties = profile.getProperties().get((Object)"textures")) != null && (iterator = properties.iterator()).hasNext()) {
                        Property property = (Property)iterator.next();
                        try {
                            Method getValueMethod = Property.class.getDeclaredMethod("getValue", new Class[0]);
                            getValueMethod.setAccessible(true);
                            return (String)getValueMethod.invoke((Object)property, new Object[0]);
                        }
                        catch (Exception e) {
                            Method valueMethod = Property.class.getDeclaredMethod("value", new Class[0]);
                            valueMethod.setAccessible(true);
                            return (String)valueMethod.invoke((Object)property, new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public ItemStack transform(ItemStack item, String usedName, String argument) {
        if (!(item.getItemMeta() instanceof SkullMeta)) {
            ClassManager.manager.getBugFinder().warn("Mistake in Config: Itemdata of type '" + usedName + "' with value '" + argument + "' can not be added to an item with material '" + item.getType().name() + "'. Don't worry I'll automatically transform the material into '" + String.valueOf(Material.PLAYER_HEAD) + ".");
            item.setType(Material.PLAYER_HEAD);
        }
        item = ItemDataPartCustomSkull.transformSkull(item, argument);
        return item;
    }

    @Override
    public int getPriority() {
        return PRIORITY_EARLY;
    }

    @Override
    public boolean removeSpaces() {
        return true;
    }

    @Override
    public String[] createNames() {
        return new String[]{"customskull", "skull"};
    }

    @Override
    public List<String> read(ItemStack i, List<String> output) {
        String skulltexture = ItemDataPartCustomSkull.readSkullTexture(i);
        if (skulltexture != null) {
            output.add("customskull:" + skulltexture);
        }
        return output;
    }

    @Override
    public boolean isSimilar(ItemStack shopItem, ItemStack playerItem, GenesisBuy buy, Player p) {
        return true;
    }
}

