/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPart;
import studio.magemonkey.genesis.managers.misc.InputReader;

public class ItemDataPartCustomModelData
extends ItemDataPart {
    @Override
    public ItemStack transform(ItemStack item, String usedName, String argument) {
        int customModelData = InputReader.getInt(argument, -1);
        if (customModelData == -1) {
            ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + argument + "' is not a valid '" + usedName + "'. It needs to be a number like '1', '12' or '64'.");
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(customModelData));
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public boolean isSimilar(ItemStack shopItem, ItemStack playerItem, GenesisBuy buy, Player p) {
        if (shopItem.hasItemMeta() == playerItem.hasItemMeta()) {
            boolean modelPresenceMatch;
            if (!shopItem.hasItemMeta()) {
                return true;
            }
            boolean bl = modelPresenceMatch = shopItem.getItemMeta().hasCustomModelData() == playerItem.getItemMeta().hasCustomModelData();
            if (modelPresenceMatch) {
                if (!shopItem.getItemMeta().hasCustomModelData()) {
                    return true;
                }
                return shopItem.getItemMeta().getCustomModelData() == playerItem.getItemMeta().getCustomModelData();
            }
            return !shopItem.getItemMeta().hasCustomModelData();
        }
        return !shopItem.hasItemMeta();
    }

    @Override
    public List<String> read(ItemStack i, List<String> output) {
        int d;
        if (i.hasItemMeta() && (d = i.getItemMeta().getCustomModelData()) != -1) {
            output.add("CustomModelData:" + d);
        }
        return output;
    }

    @Override
    public int getPriority() {
        return PRIORITY_NORMAL;
    }

    @Override
    public boolean removeSpaces() {
        return false;
    }

    @Override
    public String[] createNames() {
        return new String[]{"CustomModelData"};
    }
}

