/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.item;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.divinity.Divinity;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.item.ItemDataPartAmount;
import studio.magemonkey.genesis.managers.item.ItemDataPartArmorTrim;
import studio.magemonkey.genesis.managers.item.ItemDataPartAxolotl;
import studio.magemonkey.genesis.managers.item.ItemDataPartBanner;
import studio.magemonkey.genesis.managers.item.ItemDataPartColor;
import studio.magemonkey.genesis.managers.item.ItemDataPartCustomModelData;
import studio.magemonkey.genesis.managers.item.ItemDataPartCustomSkull;
import studio.magemonkey.genesis.managers.item.ItemDataPartDurability;
import studio.magemonkey.genesis.managers.item.ItemDataPartEnchantment;
import studio.magemonkey.genesis.managers.item.ItemDataPartGlowing;
import studio.magemonkey.genesis.managers.item.ItemDataPartItemModel;
import studio.magemonkey.genesis.managers.item.ItemDataPartItemflags;
import studio.magemonkey.genesis.managers.item.ItemDataPartKnowledgeBook;
import studio.magemonkey.genesis.managers.item.ItemDataPartLore;
import studio.magemonkey.genesis.managers.item.ItemDataPartMaterial;
import studio.magemonkey.genesis.managers.item.ItemDataPartMobEgg;
import studio.magemonkey.genesis.managers.item.ItemDataPartMobSpawner;
import studio.magemonkey.genesis.managers.item.ItemDataPartNBTTag;
import studio.magemonkey.genesis.managers.item.ItemDataPartName;
import studio.magemonkey.genesis.managers.item.ItemDataPartPlayerhead;
import studio.magemonkey.genesis.managers.item.ItemDataPartPotion;
import studio.magemonkey.genesis.managers.item.ItemDataPartPotionEffect;
import studio.magemonkey.genesis.managers.item.ItemDataPartSuspiciousStew;
import studio.magemonkey.genesis.managers.item.ItemDataPartTropicalFish;
import studio.magemonkey.genesis.managers.item.ItemDataPartUnbreaking;
import studio.magemonkey.genesis.managers.item.ItemDataPartWrittenBookInformation;
import studio.magemonkey.genesis.managers.item.ItemDataPartWrittenBookPage;
import studio.magemonkey.genesis.misc.VersionManager;

public abstract class ItemDataPart {
    public static int PRIORITY_MOST_EARLY = 0;
    public static int PRIORITY_EARLY = 10;
    public static int PRIORITY_NORMAL = 50;
    public static int PRIORITY_LATE = 80;
    public static ItemDataPart MATERIAL;
    public static ItemDataPart AMOUNT;
    public static ItemDataPart DURABILITY;
    public static ItemDataPart NAME;
    public static ItemDataPart LORE;
    public static ItemDataPart ENCHANTMENT;
    public static ItemDataPart PLAYERHEAD;
    public static ItemDataPart CUSTOMSKULL;
    public static ItemDataPart CUSTOMMODELDATA;
    public static ItemDataPart ITEMMODEL;
    public static ItemDataPart MOBSPAWNER;
    public static ItemDataPart MOBEGG;
    public static ItemDataPart ITEMFLAGS;
    public static ItemDataPart COLOR;
    public static ItemDataPart ARMORTRIM;
    public static ItemDataPart POTIONEFFECT;
    public static ItemDataPart POTION;
    public static ItemDataPart UNBREAKING;
    public static ItemDataPart BOOK;
    public static ItemDataPart BOOKPAGE;
    public static ItemDataPart BANNER;
    public static ItemDataPart AXOLOTL;
    public static ItemDataPart GLOWING;
    public static ItemDataPart KNOWLEDGEBOOK;
    public static ItemDataPart SUSPICIOUSSTEW;
    public static ItemDataPart TROPICALFISH;
    public static ItemDataPart NBTTAG;
    private static List<ItemDataPart> types;
    private final String[] names = this.createNames();

    public static void loadTypes() {
        types = new ArrayList<ItemDataPart>();
        MATERIAL = ItemDataPart.registerType(new ItemDataPartMaterial());
        AMOUNT = ItemDataPart.registerType(new ItemDataPartAmount());
        DURABILITY = ItemDataPart.registerType(new ItemDataPartDurability());
        NAME = ItemDataPart.registerType(new ItemDataPartName());
        LORE = ItemDataPart.registerType(new ItemDataPartLore());
        ENCHANTMENT = ItemDataPart.registerType(new ItemDataPartEnchantment());
        PLAYERHEAD = ItemDataPart.registerType(new ItemDataPartPlayerhead());
        CUSTOMMODELDATA = ItemDataPart.registerType(new ItemDataPartCustomModelData());
        ITEMMODEL = ItemDataPart.registerType(new ItemDataPartItemModel());
        MOBSPAWNER = ItemDataPart.registerType(new ItemDataPartMobSpawner());
        MOBEGG = ItemDataPart.registerType(new ItemDataPartMobEgg());
        CUSTOMSKULL = ItemDataPart.registerType(new ItemDataPartCustomSkull());
        ITEMFLAGS = ItemDataPart.registerType(new ItemDataPartItemflags());
        COLOR = ItemDataPart.registerType(new ItemDataPartColor());
        ARMORTRIM = ItemDataPart.registerType(new ItemDataPartArmorTrim());
        POTIONEFFECT = ItemDataPart.registerType(new ItemDataPartPotionEffect());
        POTION = ItemDataPart.registerType(new ItemDataPartPotion());
        UNBREAKING = ItemDataPart.registerType(new ItemDataPartUnbreaking());
        BANNER = ItemDataPart.registerType(new ItemDataPartBanner());
        BOOK = ItemDataPart.registerType(new ItemDataPartWrittenBookInformation());
        BOOKPAGE = ItemDataPart.registerType(new ItemDataPartWrittenBookPage());
        if (VersionManager.isAtLeast(17)) {
            AXOLOTL = ItemDataPart.registerType(new ItemDataPartAxolotl());
        }
        if (VersionManager.isAtLeast(14)) {
            SUSPICIOUSSTEW = ItemDataPart.registerType(new ItemDataPartSuspiciousStew());
            KNOWLEDGEBOOK = ItemDataPart.registerType(new ItemDataPartKnowledgeBook());
            TROPICALFISH = ItemDataPart.registerType(new ItemDataPartTropicalFish());
        }
        if (VersionManager.isAtLeast(8)) {
            NBTTAG = ItemDataPart.registerType(new ItemDataPartNBTTag());
        }
        GLOWING = ItemDataPart.registerType(new ItemDataPartGlowing());
    }

    public static ItemDataPart registerType(ItemDataPart type) {
        types.add(type);
        return type;
    }

    public static ItemDataPart detectTypeSpecial(String wholeLine) {
        if (wholeLine == null) {
            return null;
        }
        String[] parts = wholeLine.split(":", 2);
        String name = parts[0].trim();
        return ItemDataPart.detectType(name);
    }

    public static ItemDataPart detectType(String s) {
        for (ItemDataPart type : types) {
            if (!type.isType(s)) continue;
            return type;
        }
        return null;
    }

    public static ItemStack transformItem(ItemStack item, List<String> itemdata) {
        itemdata.sort((s1, s2) -> {
            ItemDataPart type1 = ItemDataPart.detectTypeSpecial(s1);
            ItemDataPart type2 = ItemDataPart.detectTypeSpecial(s2);
            if (type1 != null && type2 != null) {
                return Integer.compare(type1.getPriority(), type2.getPriority());
            }
            return 0;
        });
        for (String line : itemdata) {
            item = ItemDataPart.transformItem(item, line);
        }
        return item;
    }

    public static ItemStack transformItem(ItemStack item, String line) {
        ItemDataPart part;
        if (line == null) {
            return item;
        }
        String[] parts = line.split(":", 2);
        String name = parts[0].trim();
        String argument = null;
        if (parts.length == 2) {
            argument = parts[1].trim();
        }
        if ((part = ItemDataPart.detectType(name)) == null) {
            ClassManager.manager.getBugFinder().severe("Mistake in Config: Unable to read itemdata '" + name + ":" + argument);
            return item;
        }
        return part.transformItem(item, name, argument);
    }

    public static List<String> readItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        List<String> output = new ArrayList<String>();
        for (ItemDataPart part : types) {
            try {
                output = part.read(item, output);
            }
            catch (Exception | NoSuchMethodError throwable) {}
        }
        return output;
    }

    public static boolean isSimilar(ItemStack shopItem, ItemStack playerItem, ItemDataPart[] exceptions, GenesisBuy buy, boolean compareAmount, Player p) {
        ItemGeneratorManager manager;
        if (shopItem == null || playerItem == null) {
            return false;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Divinity") && (manager = Divinity.instance.getModuleCache().getTierManager()) != null) {
            String shopItemName = manager.getItemId(shopItem);
            String playerItemName = manager.getItemId(playerItem);
            if (shopItemName != null && playerItemName != null) {
                return shopItemName.equals(playerItemName);
            }
        }
        for (ItemDataPart part : types) {
            if (ItemDataPart.isException(exceptions, part) || !compareAmount && part == AMOUNT) continue;
            try {
                if (part.isSimilar(shopItem, playerItem, buy, p)) continue;
                return false;
            }
            catch (Exception | NoSuchMethodError throwable) {
            }
        }
        return true;
    }

    private static boolean isException(ItemDataPart[] exceptions, ItemDataPart part) {
        if (exceptions != null) {
            for (ItemDataPart exception : exceptions) {
                if (exception != part) continue;
                return true;
            }
        }
        return false;
    }

    public static List<ItemDataPart> values() {
        return types;
    }

    public boolean isType(String s) {
        if (this.names != null) {
            for (String name : this.names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void register() {
        ItemDataPart.registerType(this);
    }

    public String name() {
        return this.names[0].toUpperCase();
    }

    public ItemStack transformItem(ItemStack item, String usedName, String argument) {
        if (argument == null && this.needsArgument()) {
            return item;
        }
        if (this.removeSpaces() && argument != null) {
            argument = argument.replaceAll(" ", "");
        }
        try {
            return this.transform(item, usedName.toLowerCase(), argument);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            ClassManager.manager.getBugFinder().severe("Unable to work with itemdata '" + usedName.toLowerCase() + ":" + argument + ". Seems like it is not supported by your server version yet.");
            return item;
        }
    }

    @Deprecated
    public abstract ItemStack transform(ItemStack var1, String var2, String var3);

    public abstract boolean isSimilar(ItemStack var1, ItemStack var2, GenesisBuy var3, Player var4);

    public abstract List<String> read(ItemStack var1, List<String> var2);

    public abstract int getPriority();

    public abstract boolean removeSpaces();

    public abstract String[] createNames();

    public boolean needsArgument() {
        return true;
    }
}

