/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.features;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.pointsystem.GenesisPointsAPI;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPlugin;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginFailed;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginGadgetsMenu;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginGringotts;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginJobs;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginKingdoms;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginNone;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginPlayerPoints;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginTokenEnchant;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginTokenManager;
import studio.magemonkey.genesis.pointsystem.GenesisPointsPluginVotingPlugin;

public class PointsManager {
    private GenesisPointsPlugin pa;

    public PointsManager() {
        this(ClassManager.manager.getSettings().getPointsPlugin());
    }

    public PointsManager(PointsPlugin p) {
        if (p == null) {
            this.pa = new GenesisPointsPluginFailed();
            return;
        }
        if (p != PointsPlugin.NONE && Bukkit.getPluginManager().getPlugin(p.getPluginName()) == null) {
            ClassManager.manager.getBugFinder().severe("You defined " + p.getPluginName() + " as Points Plugin... BUT IT WAS NOT FOUND?! Please install it or use an alternative like PlayerPoints (https://www.spigotmc.org/resources/playerpoints.80745/). If you want Genesis to auto-detect your Points plugin simply set 'PointsPlugin: auto-detect'.");
            this.pa = new GenesisPointsPluginFailed();
            return;
        }
        switch (p.ordinal()) {
            case 1: {
                this.pa = new GenesisPointsPluginPlayerPoints();
                break;
            }
            case 3: {
                this.pa = new GenesisPointsPluginTokenEnchant();
                break;
            }
            case 4: {
                this.pa = new GenesisPointsPluginTokenManager();
                break;
            }
            case 5: {
                this.pa = new GenesisPointsPluginJobs();
                break;
            }
            case 6: {
                this.pa = new GenesisPointsPluginKingdoms();
                break;
            }
            case 7: {
                this.pa = new GenesisPointsPluginVotingPlugin();
                break;
            }
            case 8: {
                this.pa = new GenesisPointsPluginGadgetsMenu();
                break;
            }
            case 9: {
                this.pa = new GenesisPointsPluginGringotts();
                break;
            }
            case 0: {
                this.pa = new GenesisPointsPluginNone();
                break;
            }
            case 10: {
                GenesisPointsPlugin customPoints = GenesisPointsAPI.get(p.getCustom());
                if (customPoints == null) break;
                this.pa = customPoints;
            }
        }
        if (this.pa == null) {
            ClassManager.manager.getBugFinder().warn("No PointsPlugin was found... You need one if you want Genesis to work with Points! Get PlayerPoints here: http://dev.bukkit.org/server-mods/playerpoints/");
            this.pa = new GenesisPointsPluginFailed();
        } else {
            Genesis.log("Successfully hooked into Points plugin " + this.pa.getName() + ".");
        }
    }

    public double getPoints(OfflinePlayer player) {
        return this.pa.getPoints(player);
    }

    public double setPoints(OfflinePlayer player, double points) {
        return this.pa.setPoints(player, points);
    }

    public double givePoints(OfflinePlayer player, double points) {
        return this.pa.givePoints(player, points);
    }

    public double takePoints(OfflinePlayer player, double points) {
        return this.pa.takePoints(player, points);
    }

    public boolean usesDoubleValues() {
        return this.pa.usesDoubleValues();
    }

    public static enum PointsPlugin {
        NONE(new String[]{"none", "nothing"}),
        PLAYERPOINTS(new String[]{"PlayerPoints", "PlayerPoint", "PP"}),
        ENJIN_MINECRAFT_PLUGIN(new String[]{"EnjinMinecraftPlugin", "Enjin", "EMP"}),
        TOKENENCHANT(new String[]{"TokenEnchant", "TE", "TokenEnchants"}),
        TOKENMANAGER(new String[]{"TokenManager", "TM"}),
        Jobs(new String[]{"Jobs", "JobsReborn"}),
        KINGDOMS(new String[]{"Kingdoms", "Kingdom"}),
        VOTINGPLUGIN(new String[]{"VotingPlugin", "VP"}),
        GadetsMenu(new String[]{"GadgetsMenu"}),
        Gringotts(new String[]{"Gringotts"}),
        CUSTOM(new String[0]);

        private final String[] nicknames;
        private String customName;

        private PointsPlugin(String[] nicknames) {
            this.nicknames = nicknames;
        }

        public String getCustom() {
            return this.customName;
        }

        public void setCustom(String customName) {
            this.customName = customName;
        }

        public String getPluginName() {
            if (this.getNicknames() == null) {
                return this.customName;
            }
            if (this.getNicknames().length == 0) {
                return this.customName;
            }
            return this.getNicknames()[0];
        }

        @Generated
        public String[] getNicknames() {
            return this.nicknames;
        }
    }
}

