/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.features;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.ConfigLoader;

public class PageLayoutHandler {
    private List<GenesisBuy> items;
    private int maxRows = 6;
    private int reservedSlotsStart;
    private boolean showIfMultiplePagesOnly;

    public PageLayoutHandler(List<GenesisBuy> items, int reservedSlotsStart, boolean showIfMultiplePagesOnly) {
        this.items = items;
        this.reservedSlotsStart = reservedSlotsStart;
        this.showIfMultiplePagesOnly = showIfMultiplePagesOnly;
    }

    public PageLayoutHandler(Genesis plugin) {
        File f = new File(ClassManager.manager.getPlugin().getDataFolder().getAbsolutePath() + "/pagelayout.yml");
        try {
            YamlConfiguration config = ConfigLoader.loadConfiguration(f, false);
            this.setup((ConfigurationSection)config);
        }
        catch (InvalidConfigurationException e) {
            plugin.getClassManager().getBugFinder().severe("Unable to load '/plugins/Genesis/pagelayout.yml'. Reason: " + e.getMessage());
        }
    }

    public PageLayoutHandler(ConfigurationSection section) {
        this.setup(section);
    }

    public void setup(ConfigurationSection section) {
        this.maxRows = Math.max(1, section.getInt("MaxRows"));
        this.reservedSlotsStart = section.getInt("ReservedSlotsStart");
        this.showIfMultiplePagesOnly = section.getBoolean("ShowIfMultiplePagesOnly");
        this.items = new ArrayList<GenesisBuy>();
        if (!section.isConfigurationSection("items")) {
            return;
        }
        for (String key : section.getConfigurationSection("items").getKeys(false)) {
            List<GenesisBuy> buyItems = ClassManager.manager.getBuyItemHandler().loadItem(section.getConfigurationSection("items"), null, key);
            for (GenesisBuy buy : buyItems) {
                if (buy == null) continue;
                this.items.add(buy);
            }
        }
    }

    public boolean showIfMultiplePagesOnly() {
        return this.showIfMultiplePagesOnly;
    }

    @Generated
    public List<GenesisBuy> getItems() {
        return this.items;
    }

    @Generated
    public int getMaxRows() {
        return this.maxRows;
    }

    @Generated
    public int getReservedSlotsStart() {
        return this.reservedSlotsStart;
    }
}

