/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.features;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisMultiplier;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.misc.MathTools;

public class MultiplierHandler {
    private final Set<GenesisMultiplier> multipliers = new HashSet<GenesisMultiplier>();
    private List<String> lines;

    public MultiplierHandler(Genesis plugin) {
        if (!plugin.getConfig().getBoolean("MultiplierGroups.Enabled")) {
            return;
        }
        this.lines = plugin.getConfig().getStringList("MultiplierGroups.List");
        this.setup();
    }

    public void setup() {
        this.multipliers.clear();
        for (String s : this.lines) {
            GenesisMultiplier m = new GenesisMultiplier(s);
            if (!m.isValid()) continue;
            this.multipliers.add(m);
        }
    }

    public String calculatePriceDisplayWithMultiplier(Player p, GenesisBuy buy, ClickType clickType, double d, String message) {
        GenesisPriceType t = buy.getPriceType(clickType);
        return this.calculatePriceDisplayWithMultiplier(p, buy, clickType, d, message, MathTools.getFormatting(t), MathTools.isIntegerValue(t));
    }

    public String calculatePriceDisplayWithMultiplier(Player p, GenesisBuy buy, ClickType clickType, double d, String message, List<String> formatting, boolean integerValue) {
        d = this.calculatePriceWithMultiplier(p, buy, clickType, d);
        if (buy.getRewardType(clickType) == GenesisRewardType.ItemAll) {
            if (ClassManager.manager.getSettings().getItemAllShowFinalReward() && p != null) {
                ItemStack i = (ItemStack)buy.getReward(clickType);
                int count = ClassManager.manager.getItemStackChecker().getAmountOfFreeSpace(p, i);
                if (count == 0) {
                    return ClassManager.manager.getMessageHandler().get("Display.ItemAllEach").replace("%value%", message.replace("%number%", MathTools.displayNumber(d, formatting, integerValue)));
                }
                d *= (double)count;
            } else {
                return ClassManager.manager.getMessageHandler().get("Display.ItemAllEach").replace("%value%", message.replace("%number%", MathTools.displayNumber(d, formatting, integerValue)));
            }
        }
        return message.replace("%number%", MathTools.displayNumber(d, formatting, integerValue));
    }

    public double calculatePriceWithMultiplier(Player p, GenesisBuy buy, ClickType clickType, double d) {
        return this.calculatePriceWithMultiplier(p, buy, buy.getPriceType(clickType), d);
    }

    public double calculatePriceWithMultiplier(Player p, GenesisPriceType priceType, double d) {
        for (GenesisMultiplier m : this.multipliers) {
            d = m.calculateValue(p, priceType, d, 1);
        }
        return MathTools.round(d, 2);
    }

    public double calculatePriceWithMultiplier(Player p, GenesisBuy buy, GenesisPriceType priceType, double d) {
        for (GenesisMultiplier m : this.multipliers) {
            if (!m.isAcceptedShopItem(buy)) continue;
            d = m.calculateValue(p, priceType, d, 1);
        }
        return MathTools.round(d, 2);
    }

    public String calculateRewardDisplayWithMultiplier(Player p, GenesisBuy buy, ClickType clickType, double d, String message) {
        GenesisPriceType t = GenesisPriceType.detectType(buy.getRewardType(clickType).name());
        return this.calculateRewardDisplayWithMultiplier(p, buy, clickType, d, message, MathTools.getFormatting(t), MathTools.isIntegerValue(t));
    }

    public String calculateRewardDisplayWithMultiplier(Player p, GenesisBuy buy, ClickType clickType, double d, String message, List<String> formatting, boolean integerValue) {
        d = this.calculateRewardWithMultiplier(p, buy, clickType, d);
        if (buy.getPriceType(clickType) == GenesisPriceType.ItemAll) {
            if (ClassManager.manager.getSettings().getItemAllShowFinalReward() && p != null) {
                ItemStack i = (ItemStack)buy.getPrice(clickType);
                int count = ClassManager.manager.getItemStackChecker().getAmountOfSameItems(p, i, buy);
                if (count == 0) {
                    return ClassManager.manager.getMessageHandler().get("Display.ItemAllEach").replace("%value%", message.replace("%number%", MathTools.displayNumber(d, formatting, integerValue)));
                }
                d *= (double)count;
            } else {
                return ClassManager.manager.getMessageHandler().get("Display.ItemAllEach").replace("%value%", message.replace("%number%", MathTools.displayNumber(d, formatting, integerValue)));
            }
        }
        return message.replace("%number%", MathTools.displayNumber(d, formatting, integerValue));
    }

    public double calculateRewardWithMultiplier(Player p, GenesisBuy buy, ClickType clickType, double d) {
        return this.calculateRewardWithMultiplier(p, buy, buy.getRewardType(clickType), d);
    }

    public double calculateRewardWithMultiplier(Player p, GenesisBuy buy, GenesisRewardType rewardtype, double d) {
        for (GenesisMultiplier m : this.multipliers) {
            if (!m.isAcceptedShopItem(buy)) continue;
            d = m.calculateValue(p, GenesisPriceType.detectType(rewardtype.name()), d, 2);
        }
        return MathTools.round(d, 2);
    }

    public boolean hasMultipliers() {
        return !this.multipliers.isEmpty();
    }

    @Generated
    public Set<GenesisMultiplier> getMultipliers() {
        return this.multipliers;
    }

    @Generated
    public List<String> getLines() {
        return this.lines;
    }
}

