/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.features;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import studio.magemonkey.genesis.Genesis;

public class ItemDataStorage {
    private final Genesis plugin;
    private final String fileName = "ItemDataStorage.yml";
    private final File file;
    private FileConfiguration config = null;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy dd-MM 'at' hh:mm:ss a (E)");

    public ItemDataStorage(Genesis plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder().getAbsolutePath(), "ItemDataStorage.yml");
        this.reloadConfig();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        InputStream defConfigStream = this.plugin.getResource("ItemDataStorage.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.file);
        }
        catch (IOException e) {
            Genesis.log("Could not save ItemDataStorage.yml to " + String.valueOf(this.file));
        }
    }

    public String getDate() {
        Date dNow = new Date();
        return this.formatter.format(dNow);
    }

    public void addItemData(String playername, List<String> itemdata) {
        this.config.set(playername + "." + this.getDate(), itemdata);
        this.saveConfig();
    }
}

