/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.external;

import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.misc.NoEconomy;

public class VaultHandler {
    private Permission perms;
    private Economy economy;

    public VaultHandler(boolean eco, boolean per) {
        Genesis.log("Vault found.");
        if (eco) {
            this.setupEconomy();
        }
        if (per) {
            this.setupPermissions();
        }
    }

    private void setupEconomy() {
        RegisteredServiceProvider economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider == null) {
            ClassManager.manager.getBugFinder().warn("No Economy Plugin was found... You need one if you want to work with Money! Get it there: http://plugins.bukkit.org/.");
            this.economy = new NoEconomy();
            return;
        }
        this.economy = (Economy)economyProvider.getProvider();
    }

    private void setupPermissions() {
        RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp == null) {
            ClassManager.manager.getBugFinder().warn("No Permissions Plugin was found... You need one if you want to work with Permissions or Permission Groups! Get it there: http://plugins.bukkit.org/");
            return;
        }
        this.perms = (Permission)rsp.getProvider();
    }

    public Permission getPermission() {
        return this.perms;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

