/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.external;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.serverpinging.ServerInfo;
import studio.magemonkey.genesis.managers.serverpinging.ServerPingingManager;

public class BungeeCordManager
implements PluginMessageListener {
    public static final String PLUGIN_CHANNEL = "Genesis";
    public static final String PLUGIN_SUBCHANNEL_PLAYERINPUT = "PlayerInput";

    public void sendToServer(String server, PlayerMoveEvent event, Genesis plugin) {
        event.getPlayer().teleport(event.getPlayer().getWorld().getSpawnLocation());
        event.setCancelled(true);
        this.sendToServer(server, event.getPlayer(), plugin);
    }

    public void sendToServer(String server, Player p, Genesis plugin) {
        this.sendPluginMessage(p, plugin, "Connect", server);
    }

    public boolean sendPluginMessage(Player p, Genesis plugin, String ... args) {
        if (p == null) {
            p = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        }
        if (p != null) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            for (String arg : args) {
                if (arg == null) continue;
                out.writeUTF(arg);
            }
            p.sendPluginMessage((Plugin)plugin, "BungeeCord", out.toByteArray());
            return true;
        }
        return false;
    }

    public void sendShopPluginMessage(Player p, String subchannel, String argumentA, String argumentB, String argumentC) {
        this.sendPluginMessage(p, ClassManager.manager.getPlugin(), PLUGIN_CHANNEL, subchannel, argumentA, argumentB, argumentC);
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        try {
            if (!channel.equals("BungeeCord")) {
                return;
            }
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
            String subchannel = in.readUTF();
            if (subchannel.equals("PlayerCount")) {
                String server = in.readUTF();
                int playercount = in.readInt();
                ServerPingingManager m = ClassManager.manager.getServerPingingManager();
                if (m == null) {
                    throw new RuntimeException("Received PlayerCount plugin message but server pinging is not even loaded?!");
                }
                for (ServerInfo c : ClassManager.manager.getServerPingingManager().getList().getInfos().values()) {
                    if (!c.getHost().equalsIgnoreCase(server)) continue;
                    c.setPlayers(playercount);
                    c.setOnline(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void executeCommand(Player p, String command) {
        this.sendPluginMessage(p, ClassManager.manager.getPlugin(), PLUGIN_CHANNEL, "Command", command);
    }

    public void playerInputNotification(Player p, String type, String additionalInfo) {
        this.sendShopPluginMessage(p, PLUGIN_SUBCHANNEL_PLAYERINPUT, p.getUniqueId().toString(), type, additionalInfo);
    }
}

