/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShops;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.events.GenesisLoadShopItemsEvent;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.ConfigLoader;

public class GenesisConfigShop
extends GenesisShop {
    private String ymlName;
    private File f;
    private FileConfiguration config;
    private ConfigurationSection section;

    public GenesisConfigShop(int shopId, String ymlName, GenesisShops shopHandler) {
        this(shopId, new File(ClassManager.manager.getPlugin().getDataFolder().getAbsolutePath() + "/shops/" + ymlName), shopHandler);
        this.ymlName = ymlName;
    }

    public GenesisConfigShop(int shopId, File f, GenesisShops shopHandler) {
        this(shopId, f, shopHandler, null);
    }

    public GenesisConfigShop(int shopId, File f, GenesisShops shopHandler, ConfigurationSection sectionOptional) {
        super(shopId);
        this.f = f;
        try {
            this.config = ConfigLoader.loadConfiguration(f, true);
        }
        catch (InvalidConfigurationException e) {
            ClassManager.manager.getBugFinder().severe("Invalid Configuration! File: /shops/" + this.ymlName + " Cause: " + e.getMessage());
            String name = this.ymlName.replace(".yml", "");
            this.setSignText("[" + name + "]");
            this.setNeedPermToCreateSign(true);
            this.setShopName(name);
            ItemStack i = new ItemStack(Material.WHITE_WOOL, 1);
            ItemMeta m = i.getItemMeta();
            m.setDisplayName(String.valueOf(ChatColor.RED) + "Your Config File contains mistakes! (" + this.ymlName + ")");
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.YELLOW) + "For more information check /plugins/Genesis/BugFinder.yml out!")));
            m.setLore(lore);
            i.setItemMeta(m);
            this.addShopItem(new GenesisBuy(GenesisRewardType.Command, GenesisPriceType.Nothing, "tell %player% the config file (" + this.ymlName + ") contains mistakes...", null, "", 0, "", name), i, ClassManager.manager);
            this.finishedAddingItems();
            return;
        }
        this.setup(shopHandler, (ConfigurationSection)(sectionOptional == null ? this.config : sectionOptional));
    }

    public void setup(GenesisShops shopHandler, ConfigurationSection section) {
        this.section = section;
        this.addDefaults();
        this.setShopName(section.getString("ShopName"));
        this.setDisplayName(section.getString("DisplayName"));
        this.setSignText(section.getString("signs.text"));
        this.setNeedPermToCreateSign(section.getBoolean("signs.NeedPermissionToCreateSign"));
        this.setManualInventoryRows(section.getInt("InventoryRows", -1));
        String commands = section.getString("Command");
        if (commands != null) {
            this.setCommands(commands.split(":"));
        }
        ClassManager.manager.getSettings().update(this);
        this.loadItems();
        GenesisLoadShopItemsEvent event = new GenesisLoadShopItemsEvent(shopHandler, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.finishedAddingItems();
    }

    @Override
    public void finishedAddingItems() {
        super.finishedAddingItems();
        this.fillInventory();
    }

    public void fillInventory() {
        if (this.config.isSet("InventoryFill")) {
            Material material;
            try {
                material = Material.valueOf((String)this.config.getString("InventoryFill").toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ignored) {
                material = Material.BLACK_STAINED_GLASS_PANE;
                Genesis.log("Your InventoryFill parameter is invalid and was replaced with its default: " + this.config.getString("InventoryFill"));
            }
            for (int i = 0; i < this.getInventorySize(); ++i) {
                if (this.isFilled(i)) continue;
                GenesisBuy buy = new GenesisBuy(GenesisRewardType.Nothing, GenesisPriceType.Nothing, null, null, null, i, null, "internal_placeholder_" + i, null, null, null);
                ItemStack fillerItem = new ItemStack(material);
                ItemMeta meta = fillerItem.getItemMeta();
                meta.setDisplayName(" ");
                fillerItem.setItemMeta(meta);
                buy.setItem(fillerItem, false);
                this.addShopItem(buy, buy.getItem(), ClassManager.manager);
            }
        }
    }

    public ConfigurationSection getConfigurationSection() {
        return this.section;
    }

    public void saveConfig() {
        try {
            this.config.save(this.f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadConfig() {
        this.f = new File(ClassManager.manager.getPlugin().getDataFolder().getAbsolutePath() + "/shops/" + this.ymlName);
        this.config = YamlConfiguration.loadConfiguration((File)this.f);
        InputStream defConfigStream = ClassManager.manager.getPlugin().getResource(this.f.getName());
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void addDefault(String name, String rewardType, String priceType, Object reward, Object price, List<String> menuitem, String message, int loc, String permission) {
        ConfigurationSection section = this.section.getConfigurationSection("shop").createSection(name);
        section.set("RewardType", (Object)rewardType);
        section.set("PriceType", (Object)priceType);
        section.set("Price", price);
        section.set("Reward", reward);
        section.set("MenuItem", menuitem);
        section.set("Message", (Object)message);
        section.set("InventoryLocation", (Object)loc);
        section.set("ExtraPermission", (Object)permission);
    }

    public void addDefaults() {
        this.section.addDefault("ShopName", (Object)"ExtraShop");
        this.section.addDefault("signs.text", (Object)"[ExtraShop]");
        this.section.addDefault("signs.NeedPermissionToCreateSign", (Object)false);
        if (this.section.getConfigurationSection("shop") == null && this.section.getConfigurationSection("itemshop") == null && this.section.getConfigurationSection("quickshop") == null) {
            this.section.createSection("shop");
            ArrayList<String> menuItem = new ArrayList<String>();
            menuItem.add("type:STONE");
            menuItem.add("amount:1");
            menuItem.add("name:&8Example");
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("tell %name% Example");
            this.addDefault("Example", "command", "money", cmd, 5000, menuItem, "", 1, "");
            this.config.options().copyDefaults(true);
            this.saveConfig();
        }
    }

    @Override
    public int getInventorySize() {
        if (this.section.getInt("InventorySize") != 0) {
            return this.section.getInt("InventorySize");
        }
        return super.getInventorySize();
    }

    public void loadItems() {
        ConfigurationSection c = this.section.getConfigurationSection("shop");
        if (c != null) {
            for (String key : c.getKeys(false)) {
                ClassManager.manager.getBuyItemHandler().loadItem(c, this, key);
            }
        }
    }

    private boolean isFilled(int location) {
        return this.getItems().stream().anyMatch(buy -> buy.getInventoryLocation() == location);
    }

    @Override
    public void reloadShop() {
        this.reloadConfig();
    }

    @Generated
    public String getYmlName() {
        return this.ymlName;
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }
}

