/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.api.GenesisAddon;
import studio.magemonkey.genesis.api.GenesisAddonConfig;
import studio.magemonkey.genesis.managers.ClassManager;

public class FileHandler {
    public void exportConfigs(Genesis plugin) {
        this.copyDefaultsFromJar(plugin, "config.yml", "messages.yml");
        if (!new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "pagelayout.yml").exists()) {
            this.copyFromJar((Plugin)plugin, (Plugin)plugin, false, "pagelayout.yml");
        }
    }

    public void exportShops(Genesis plugin) {
        File folder = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "shops" + File.separator);
        if (!folder.isFile() & !folder.isDirectory()) {
            this.copyFromJar((Plugin)plugin, (Plugin)plugin, true, "BungeeCordServers.yml", "BuyShop.yml", "LilyPadServers.yml", "Menu.yml", "PointShop.yml", "GameShop.yml", "HugeShop.yml", "Skulls.yml", "WeekShop.yml", "PlayerCommands.yml", "Commands.yml");
        }
    }

    public void exportLanguages(Genesis plugin) {
        if (!new File(String.valueOf(plugin.getDataFolder()) + File.separator + "lang/en-us.yml").exists()) {
            plugin.saveResource("lang/en-us.yml", false);
        }
        if (!new File(String.valueOf(plugin.getDataFolder()) + File.separator + "lang/zh-cn.yml").exists()) {
            plugin.saveResource("lang/zh-cn.yml", false);
        }
    }

    public void copyDefaultsFromJar(GenesisAddon addon, String filename) {
        this.copyDefaultsFromJar((Plugin)addon, (Plugin)addon.getGenesis(), filename, "addons/" + addon.getAddonName() + "/" + filename);
    }

    public void copyDefaultsFromJar(Genesis plugin, String ... files) {
        for (String filename : files) {
            if (filename == null) continue;
            this.copyDefaultsFromJar(plugin, filename);
        }
    }

    public void copyDefaultsFromJar(Genesis plugin, String filename) {
        this.copyDefaultsFromJar((Plugin)plugin, (Plugin)plugin, filename, filename);
    }

    public void copyDefaultsFromJar(Plugin resourceHolder, Plugin folderHolder, String filename, String outputfilename) {
        File write = new File(String.valueOf(folderHolder.getDataFolder()) + File.separator + outputfilename);
        if (!write.exists()) {
            this.copyFromJar(resourceHolder, folderHolder, false, filename, outputfilename);
            return;
        }
        boolean change = false;
        try {
            this.copyFromJar(resourceHolder, folderHolder, false, filename, "temp");
            File read = new File(String.valueOf(folderHolder.getDataFolder()) + File.separator + "temp");
            if (read.exists()) {
                GenesisAddonConfig configw = new GenesisAddonConfig(resourceHolder, write);
                GenesisAddonConfig configr = new GenesisAddonConfig(resourceHolder, read);
                for (String key : configr.getConfig().getKeys(true)) {
                    if (configw.getConfig().contains(key)) continue;
                    configw.getConfig().addDefault(key, configr.getConfig().get(key));
                    change = true;
                }
                if (change) {
                    configw.getConfig().options().copyDefaults(true);
                    configw.save();
                }
                read.delete();
            }
        }
        catch (Exception e) {
            ClassManager.manager.getBugFinder().warn("Unable to load config lines of file " + filename);
        }
    }

    public void copyFromJar(Plugin resourceHolder, Plugin folderHolder, boolean shop, String ... files) {
        for (String filename : files) {
            if (filename == null) continue;
            this.copyFromJar(resourceHolder, folderHolder, shop, filename, filename);
        }
    }

    public void copyFromJar(Plugin resourceHolder, Plugin folderHolder, boolean shop, String filename, String outputfilename) {
        Object additional = shop ? "shops" + File.separator : "";
        File file = new File(String.valueOf(folderHolder.getDataFolder()) + File.separator + (String)additional + outputfilename);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream in = resourceHolder.getResource(filename);
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyFromJar(GenesisAddon addon, String filename) {
        this.copyFromJar((Plugin)addon, (Plugin)addon.getGenesis(), false, filename, "/addons/" + addon.getAddonName() + "/" + filename);
    }
}

