/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import studio.magemonkey.genesis.managers.ClassManager;

public class ConfigKeyCompleter {
    public static void checkConfig() {
        File f2;
        InputStream is = ClassManager.manager.getPlugin().getResource("config.yml");
        assert (is != null);
        File f = new File(ClassManager.manager.getPlugin().getDataFolder(), "config.yml");
        try {
            f2 = File.createTempFile("config-cache", "yml");
            ConfigKeyCompleter.copyInputStreamToFile(is, f2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConfigKeyCompleter.addKeys(f, f2);
    }

    private static void checkEnUsLanguage() {
        File f2;
        InputStream is = ClassManager.manager.getPlugin().getResource("lang/en-us.yml");
        assert (is != null);
        File f = new File(ClassManager.manager.getPlugin().getDataFolder(), "lang/en-us.yml");
        try {
            f2 = File.createTempFile("en-us-lang-cache", "yml");
            ConfigKeyCompleter.copyInputStreamToFile(is, f2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConfigKeyCompleter.addKeys(f, f2);
    }

    private static void addKeys(File f, File f2) {
        YamlConfiguration c = YamlConfiguration.loadConfiguration((File)f);
        YamlConfiguration c2 = YamlConfiguration.loadConfiguration((File)f2);
        Set key = c.getKeys(true);
        Set key2 = c2.getKeys(true);
        HashSet willAdds = new HashSet(key2);
        willAdds.removeAll(key);
        for (String configKey : willAdds) {
            String value = c2.getString(configKey);
            c.set(configKey, (Object)value);
        }
        f2.delete();
    }

    public static void checkLanguages() {
        ConfigKeyCompleter.checkEnUsLanguage();
        ConfigKeyCompleter.checkZhCnLanguage();
    }

    private static void checkZhCnLanguage() {
        File f2;
        InputStream is = ClassManager.manager.getPlugin().getResource("lang/zh-cn.yml");
        assert (is != null);
        File f = new File(ClassManager.manager.getPlugin().getDataFolder(), "lang/zh-cn.yml");
        try {
            f2 = File.createTempFile("zh-cn-lang-cache", "yml");
            ConfigKeyCompleter.copyInputStreamToFile(is, f2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConfigKeyCompleter.addKeys(f, f2);
    }

    private static void copyInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
    }
}

