/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.events.GenesisChoosePageLayoutEvent;
import studio.magemonkey.genesis.events.GenesisDisplayItemEvent;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.features.PageLayoutHandler;

public class ShopCustomizer {
    public Inventory createInventory(GenesisShop shop, Set<GenesisBuy> items, Player p, ClassManager m, int page, int highestPage, GenesisShopHolder oldShopHolder) {
        GenesisShopHolder holder = new GenesisShopHolder(shop, oldShopHolder);
        holder.setPage(page);
        holder.setHighestPage(highestPage);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)shop.getInventorySize(), (String)shop.getValidDisplayName(p, holder));
        return this.createInventory(shop, items, p, m, inventory, holder, page);
    }

    public Inventory createInventory(GenesisShop shop, Set<GenesisBuy> items, Player p, ClassManager m, Inventory inventory, int page, int highestPage) {
        if (inventory.getHolder() instanceof GenesisShopHolder) {
            GenesisShopHolder holder = (GenesisShopHolder)inventory.getHolder();
            return this.createInventory(shop, items, p, m, inventory, holder, page);
        }
        return inventory;
    }

    public Inventory createInventory(GenesisShop shop, Set<GenesisBuy> items, Player p, ClassManager m, Inventory inventory, GenesisShopHolder holder, int page) {
        boolean bl;
        int slot;
        holder.setPage(page);
        LinkedHashMap<Integer, GenesisBuy> everything = new LinkedHashMap<Integer, GenesisBuy>();
        PageLayoutHandler layout = ClassManager.manager.getPageLayoutHandler();
        GenesisChoosePageLayoutEvent event = new GenesisChoosePageLayoutEvent(shop, shop.getShopName(), layout);
        Bukkit.getPluginManager().callEvent((Event)event);
        layout = event.getLayout();
        int maxRows = layout.getMaxRows();
        int itemsPerPage = layout.getReservedSlotsStart() - 1;
        int itemsPerPageOnePage = 9 * maxRows;
        int pageSlotStart = itemsPerPage * page;
        int pageSlotEnd = itemsPerPage * (page + 1) - 1;
        for (GenesisBuy genesisBuy : items) {
            if (genesisBuy == null || !this.showItem(shop, holder, genesisBuy, p, inventory, everything)) continue;
            slot = this.getSlot(inventory, everything, genesisBuy);
            everything.put(slot, genesisBuy);
        }
        int highestSlot = 0;
        Iterator iterator = everything.keySet().iterator();
        while (iterator.hasNext()) {
            slot = (Integer)iterator.next();
            highestSlot = Math.max(highestSlot, slot);
        }
        boolean bl2 = false;
        if (page == 0 && highestSlot < itemsPerPageOnePage && layout.showIfMultiplePagesOnly()) {
            pageSlotEnd = itemsPerPageOnePage;
        } else {
            bl = true;
        }
        LinkedHashMap<Integer, GenesisBuy> locs = new LinkedHashMap<Integer, GenesisBuy>();
        Iterator iterator2 = everything.keySet().iterator();
        while (iterator2.hasNext()) {
            int slot2 = (Integer)iterator2.next();
            if (slot2 < pageSlotStart || slot2 > pageSlotEnd) continue;
            GenesisBuy buy3 = (GenesisBuy)everything.get(slot2);
            int realSlot = slot2 - pageSlotStart;
            locs.put(realSlot, buy3);
            this.addItem(inventory, buy3.getItem(), realSlot, shop.isDisplaying(), p, buy3, shop, holder);
        }
        int highestPage = highestSlot / itemsPerPage;
        holder.setItems(locs, page, bl ? highestPage : 0);
        if (bl) {
            for (GenesisBuy buy : layout.getItems()) {
                if (!this.showItem(shop, holder, buy, p, inventory, locs)) continue;
                if (buy.getInventoryLocation() < 0 || buy.getInventoryLocation() >= itemsPerPageOnePage) {
                    ClassManager.manager.getBugFinder().warn("Unable to add pagelayout item '" + buy.getName() + "': Inventory location needs to be between 1 and " + itemsPerPageOnePage + " with 'MaxRows' set to '" + layout.getMaxRows() + "'.");
                    continue;
                }
                locs.put(buy.getInventoryLocation(), buy);
                buy.updateShop(shop, buy.getItem(), m, false);
                this.addItem(inventory, buy.getItem(), buy.getInventoryLocation(), shop.isDisplaying(), p, buy, shop, holder);
            }
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (locs.containsKey(i)) continue;
            inventory.setItem(i, null);
        }
        return inventory;
    }

    private void addItem(Inventory inventory, ItemStack item, int slot, boolean displaying, Player p, GenesisBuy buy, GenesisShop shop, GenesisShopHolder holder) {
        ItemStack current;
        if (displaying && p != null && item.hasItemMeta() && !buy.isFixItem()) {
            item = ClassManager.manager.getItemStackTranslator().translateItemStack(buy, shop, holder, item.clone(), p, true);
        }
        if ((current = inventory.getItem(slot)) != null && current.getType() == Material.PLAYER_HEAD && ClassManager.manager.getItemStackChecker().isEqualShopItemAdvanced(item, current, true, p)) {
            return;
        }
        inventory.setItem(slot, item);
    }

    public boolean showItem(GenesisShop shop, GenesisShopHolder holder, GenesisBuy buy, Player p, Inventory inventory, Map<Integer, GenesisBuy> filledLocs) {
        if (filledLocs.containsKey(buy.getInventoryLocation()) && filledLocs.get(buy.getInventoryLocation()) != buy) {
            return false;
        }
        if (p == null) {
            return true;
        }
        if (ClassManager.manager.getSettings().getPropertyBoolean(0, buy) & !buy.hasPermission(p, false, null)) {
            return false;
        }
        if (!buy.meetsCondition(holder, p)) {
            return false;
        }
        GenesisDisplayItemEvent event = new GenesisDisplayItemEvent(p, shop, buy, inventory);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public int getSlot(Inventory inventory, Map<Integer, GenesisBuy> everything, GenesisBuy buy) {
        if (buy.getInventoryLocation() == -1) {
            return this.getFirstFreeSlot(inventory, everything);
        }
        return buy.getInventoryLocation();
    }

    public int getFirstFreeSlot(Inventory inventory, Map<Integer, GenesisBuy> everything) {
        for (int i = 0; i < 5000; ++i) {
            if (everything.containsKey(i)) continue;
            return i;
        }
        return -1;
    }
}

