/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.FileHandler;

public class MessageHandler {
    private final Genesis plugin;
    private String fileName = "lang" + File.separator + "en-us.yml";
    private FileConfiguration config;

    public MessageHandler(Genesis plugin) {
        this.plugin = plugin;
        this.setupLocate();
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void reloadConfig() {
        this.setupLocate();
        InputStream defConfigStream = this.plugin.getResource("lang/" + this.fileName);
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void sendMessage(String node, CommandSender sender) {
        this.sendMessage(node, sender, null, null, null, null, null);
    }

    public void sendMessage(String node, CommandSender sender, String offlineTarget) {
        this.sendMessage(node, sender, offlineTarget, null, null, null, null);
    }

    public void sendMessage(String node, CommandSender sender, Player target) {
        this.sendMessage(node, sender, null, target, null, null, null);
    }

    public void sendMessage(String node, CommandSender sender, String offlineTarget, Player target, GenesisShop shop, GenesisShopHolder holder, GenesisBuy item) {
        if (sender != null) {
            if (node == null || node.equals("")) {
                return;
            }
            String message = this.get(node, target, shop, holder, item);
            if (message == null || message.length() < 2) {
                return;
            }
            if (offlineTarget != null) {
                message = message.replace("%player%", offlineTarget).replace("%name%", offlineTarget).replace("%target%", offlineTarget);
            }
            this.sendMessageDirect(message, sender);
        }
    }

    public void sendMessageDirect(String message, CommandSender sender) {
        if (sender != null) {
            if (message == null || message.length() < 2) {
                return;
            }
            String colors = "";
            for (String line : message.split("\\\\n")) {
                sender.sendMessage(colors + line);
                colors = ChatColor.getLastColors((String)line);
            }
        }
    }

    public String get(String node) {
        return this.get(node, null, null, null, null);
    }

    public String getRaw(String node) {
        return this.config.getString(node, node);
    }

    private String get(String node, Player target, GenesisShop shop, GenesisShopHolder holder, GenesisBuy item) {
        return this.replace(this.config.getString(node, node), target, shop, holder, item);
    }

    private String replace(String message, Player target, GenesisShop shop, GenesisShopHolder holder, GenesisBuy item) {
        return ClassManager.manager.getStringManager().transform(message, item, shop, holder, target);
    }

    public void setupLocate() {
        String LangCode = ClassManager.manager.getSettings().getLanguage();
        if (Objects.equals(LangCode, null) || LangCode.equals("")) {
            LangCode = "en-us";
            this.plugin.getConfig().set("Language", (Object)"en-us");
        }
        this.fileName = "lang/" + LangCode + ".yml";
        File file = new File(this.plugin.getDataFolder(), this.fileName);
        if (!file.exists()) {
            LangCode = "en-us";
            this.plugin.getConfig().set("Language", (Object)"en-us");
            FileHandler fh = new FileHandler();
            File lang = new File(this.plugin.getDataFolder(), "lang" + File.separator + "en-us.yml");
            if (!lang.exists()) {
                fh.exportLanguages(this.plugin);
                this.fileName = "lang/" + LangCode + ".yml";
                file = new File(this.plugin.getDataFolder(), "lang" + File.separator + this.fileName);
                this.config = YamlConfiguration.loadConfiguration((File)file);
                return;
            }
            this.fileName = "lang/" + LangCode + ".yml";
            file = new File(this.plugin.getDataFolder(), "lang" + File.separator + this.fileName);
            ClassManager.manager.getBugFinder().warn("The corresponding message file cannot be found and fallback to en-us. (maybe you didn't put the message file in the plugin folder, or didn't have the message file)");
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
    }
}

