/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.managers;

import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.api.GenesisAddon;
import studio.magemonkey.genesis.core.GenesisShops;
import studio.magemonkey.genesis.core.conditions.GenesisConditionType;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.events.GenesisRegisterTypesEvent;
import studio.magemonkey.genesis.managers.BuyItemHandler;
import studio.magemonkey.genesis.managers.MessageHandler;
import studio.magemonkey.genesis.managers.ShopCustomizer;
import studio.magemonkey.genesis.managers.config.ConfigHandler;
import studio.magemonkey.genesis.managers.config.FileHandler;
import studio.magemonkey.genesis.managers.external.BungeeCordManager;
import studio.magemonkey.genesis.managers.external.LanguageManager;
import studio.magemonkey.genesis.managers.external.PlaceholderAPIHandler;
import studio.magemonkey.genesis.managers.external.VaultHandler;
import studio.magemonkey.genesis.managers.external.spawners.ISpawnEggHandler;
import studio.magemonkey.genesis.managers.external.spawners.ISpawnerHandler;
import studio.magemonkey.genesis.managers.external.spawners.SpawnerHandlerVanilla;
import studio.magemonkey.genesis.managers.external.spawners.SpawnersHandlerEpicSpawners;
import studio.magemonkey.genesis.managers.external.spawners.SpawnersHandlerSilkSpawners;
import studio.magemonkey.genesis.managers.features.AutoRefreshHandler;
import studio.magemonkey.genesis.managers.features.BugFinder;
import studio.magemonkey.genesis.managers.features.ItemDataStorage;
import studio.magemonkey.genesis.managers.features.MultiplierHandler;
import studio.magemonkey.genesis.managers.features.PageLayoutHandler;
import studio.magemonkey.genesis.managers.features.PlayerDataHandler;
import studio.magemonkey.genesis.managers.features.PointsManager;
import studio.magemonkey.genesis.managers.features.StorageManager;
import studio.magemonkey.genesis.managers.features.TransactionLog;
import studio.magemonkey.genesis.managers.item.ItemDataPart;
import studio.magemonkey.genesis.managers.item.ItemStackChecker;
import studio.magemonkey.genesis.managers.item.ItemStackCreator;
import studio.magemonkey.genesis.managers.item.ItemStackTranslator;
import studio.magemonkey.genesis.managers.misc.StringManager;
import studio.magemonkey.genesis.managers.serverpinging.ServerPingingManager;
import studio.magemonkey.genesis.misc.MathTools;
import studio.magemonkey.genesis.settings.Settings;

public class ClassManager {
    public static ClassManager manager;
    private final ItemStackChecker itemStackChecker;
    private final StringManager stringManager;
    private final MessageHandler messageHandler;
    private final ItemStackCreator itemStackCreator;
    private final ItemStackTranslator itemStackTranslator;
    private final BuyItemHandler buyItemHandler;
    private final ConfigHandler configHandler;
    private final BugFinder bugFinder;
    private final Genesis plugin;
    private final Settings settings;
    private final MultiplierHandler multiplierHandler;
    private final StorageManager storageManager;
    private final ItemDataStorage itemDataStorage;
    private final PlayerDataHandler playerDataHandler;
    private PointsManager pointsManager;
    private VaultHandler vaulthandler;
    private PlaceholderAPIHandler placeholderHandler;
    private GenesisShops shops;
    private PageLayoutHandler pageLayoutHandler;
    private BungeeCordManager bungeeCordManager;
    private ShopCustomizer customizer;
    private TransactionLog transactionLog;
    private ServerPingingManager serverPingingManager;
    private AutoRefreshHandler autoRefreshHandler;
    private ISpawnEggHandler spawnEggHandler;
    private ISpawnerHandler spawnerHandler;
    private LanguageManager languageManager;

    public ClassManager(Genesis plugin) {
        this.plugin = plugin;
        manager = this;
        this.settings = new Settings();
        new FileHandler().exportConfigs(plugin);
        GenesisRewardType.loadTypes();
        GenesisPriceType.loadTypes();
        GenesisConditionType.loadTypes();
        ItemDataPart.loadTypes();
        this.playerDataHandler = new PlayerDataHandler();
        this.configHandler = new ConfigHandler(plugin);
        MathTools.init(this.settings.getNumberLocale(), this.settings.getNumberGroupingSize());
        this.storageManager = new StorageManager(plugin);
        this.bugFinder = new BugFinder(plugin);
        this.itemDataStorage = new ItemDataStorage(plugin);
        this.multiplierHandler = new MultiplierHandler(plugin);
        this.stringManager = new StringManager();
        this.itemStackCreator = new ItemStackCreator();
        this.itemStackTranslator = new ItemStackTranslator();
        this.buyItemHandler = new BuyItemHandler();
        this.itemStackChecker = new ItemStackChecker();
        this.messageHandler = new MessageHandler(plugin);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderHandler = new PlaceholderAPIHandler();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("LangUtils")) {
            this.languageManager = new LanguageManager();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("SilkSpawners")) {
            try {
                Class.forName("de.dustplanet.util.SilkUtil");
                SpawnersHandlerSilkSpawners h = new SpawnersHandlerSilkSpawners();
                this.spawnerHandler = h;
                this.spawnEggHandler = h;
            }
            catch (ClassNotFoundException e) {
                this.getBugFinder().warn("It seems like you have 'SilkSpawners' installed, but Genesis does not recognize the API of the plugin. Note: There are different SilkSpawners plugins around. The one Genesis can hook into is https://www.spigotmc.org/resources/7811/. Others are simply ignored.");
            }
        } else {
            this.spawnerHandler = Bukkit.getPluginManager().isPluginEnabled("EpicSpawners") ? new SpawnersHandlerEpicSpawners() : new SpawnerHandlerVanilla();
        }
    }

    public void setupDependentClasses() {
        Bukkit.getPluginManager().callEvent((Event)new GenesisRegisterTypesEvent());
        FileConfiguration config = this.plugin.getConfig();
        this.plugin.getInventoryListener().init(config.getInt("ClickDelay"), config.getInt("ClickSpamKick.ClickDelay"), config.getInt("ClickSpamKick.Warnings"), config.getInt("ClickSpamKick.ForgetTime"));
        this.pageLayoutHandler = new PageLayoutHandler(this.plugin);
        this.pointsManager = new PointsManager();
        this.shops = new GenesisShops(this.plugin, this.settings);
        if (this.settings.getVaultEnabled()) {
            Plugin VaultPlugin = Bukkit.getServer().getPluginManager().getPlugin("Vault");
            if (VaultPlugin == null) {
                manager.getBugFinder().warn("Vault was not found... You need it if you want to work with Permissions, Permission Groups or Money! Get it there: https://www.spigotmc.org/resources/vault.34315/");
            } else {
                this.vaulthandler = new VaultHandler(this.settings.getMoneyEnabled(), this.settings.getPermissionsEnabled());
            }
        }
        if (this.settings.getBalanceVariableEnabled() || this.settings.getBalancePointsVariableEnabled() || this.settings.getProperty(0).containsValueAny(true)) {
            this.customizer = new ShopCustomizer();
        }
        if (this.settings.getTransactionLogEnabled()) {
            this.transactionLog = new TransactionLog(this.plugin);
        }
        if (this.settings.getServerPingingEnabled(false)) {
            this.serverPingingManager = new ServerPingingManager(this.plugin);
            this.getServerPingingManager().getServerPingingRunnableHandler().start(this.settings.getServerPingingSpeed(), this.plugin, this.getServerPingingManager());
            this.getServerPingingManager().setReadyToTransform(true);
        }
        if (this.settings.getBungeeCordServerEnabled()) {
            this.bungeeCordManager = new BungeeCordManager();
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
            Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, "BungeeCord", (PluginMessageListener)this.bungeeCordManager);
        }
        if (this.settings.getAutoRefreshSpeed() > 0) {
            this.autoRefreshHandler = new AutoRefreshHandler();
            this.autoRefreshHandler.start(this.settings.getAutoRefreshSpeed(), this.plugin);
        }
        if (this.plugin.getAPI().getEnabledAddons() != null) {
            for (GenesisAddon addon : this.plugin.getAPI().getEnabledAddons()) {
                addon.genesisFinishedLoading();
            }
        }
    }

    public VaultHandler getVaultHandler() {
        if (this.vaulthandler == null) {
            return new VaultHandler(manager.getSettings().getMoneyEnabled(), manager.getSettings().getPointsEnabled());
        }
        return this.vaulthandler;
    }

    public BungeeCordManager getBungeeCordManager() {
        if (this.bungeeCordManager == null) {
            this.bungeeCordManager = new BungeeCordManager();
        }
        return this.bungeeCordManager;
    }

    public ShopCustomizer getShopCustomizer() {
        if (this.customizer == null) {
            this.customizer = new ShopCustomizer();
        }
        return this.customizer;
    }

    @Generated
    public ItemStackChecker getItemStackChecker() {
        return this.itemStackChecker;
    }

    @Generated
    public StringManager getStringManager() {
        return this.stringManager;
    }

    @Generated
    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    @Generated
    public ItemStackCreator getItemStackCreator() {
        return this.itemStackCreator;
    }

    @Generated
    public ItemStackTranslator getItemStackTranslator() {
        return this.itemStackTranslator;
    }

    @Generated
    public BuyItemHandler getBuyItemHandler() {
        return this.buyItemHandler;
    }

    @Generated
    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    @Generated
    public BugFinder getBugFinder() {
        return this.bugFinder;
    }

    @Generated
    public Genesis getPlugin() {
        return this.plugin;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public MultiplierHandler getMultiplierHandler() {
        return this.multiplierHandler;
    }

    @Generated
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Generated
    public ItemDataStorage getItemDataStorage() {
        return this.itemDataStorage;
    }

    @Generated
    public PlayerDataHandler getPlayerDataHandler() {
        return this.playerDataHandler;
    }

    @Generated
    public PointsManager getPointsManager() {
        return this.pointsManager;
    }

    @Generated
    public PlaceholderAPIHandler getPlaceholderHandler() {
        return this.placeholderHandler;
    }

    @Generated
    public GenesisShops getShops() {
        return this.shops;
    }

    @Generated
    public PageLayoutHandler getPageLayoutHandler() {
        return this.pageLayoutHandler;
    }

    @Generated
    public TransactionLog getTransactionLog() {
        return this.transactionLog;
    }

    @Generated
    public ServerPingingManager getServerPingingManager() {
        return this.serverPingingManager;
    }

    @Generated
    public AutoRefreshHandler getAutoRefreshHandler() {
        return this.autoRefreshHandler;
    }

    @Generated
    public ISpawnEggHandler getSpawnEggHandler() {
        return this.spawnEggHandler;
    }

    @Generated
    public ISpawnerHandler getSpawnerHandler() {
        return this.spawnerHandler;
    }

    @Generated
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }
}

