/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.listeners;

import java.util.HashMap;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisShop;

public class SignListener
implements Listener {
    private boolean signsEnabled;
    private final Genesis plugin;

    public SignListener(boolean signsEnabled, Genesis plugin) {
        this.signsEnabled = signsEnabled;
        this.plugin = plugin;
    }

    private GenesisShop getGenesisSign(String line) {
        if (line == null || line.isBlank()) {
            return null;
        }
        line = line.toLowerCase();
        HashMap<Integer, GenesisShop> set = this.plugin.getClassManager().getShops().getShops();
        for (Integer s : set.keySet()) {
            GenesisShop shop = (GenesisShop)set.get(s);
            String signText = shop.getSignText();
            if (signText == null || !line.endsWith(signText.toLowerCase())) continue;
            return shop;
        }
        return null;
    }

    @EventHandler
    public void createSign(SignChangeEvent e) {
        if (!this.signsEnabled) {
            return;
        }
        GenesisShop shop = this.getGenesisSign(e.getLine(0));
        if (shop != null) {
            if (shop.needPermToCreateSign() && !e.getPlayer().hasPermission("Genesis.createSign")) {
                this.plugin.getClassManager().getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)e.getPlayer());
                e.setCancelled(true);
                return;
            }
            if (e.getLine(0) != "") {
                e.setLine(0, this.plugin.getClassManager().getStringManager().transform(e.getLine(0)));
            }
            if (e.getLine(1) != "") {
                e.setLine(1, this.plugin.getClassManager().getStringManager().transform(e.getLine(1)));
            }
            if (e.getLine(2) != "") {
                e.setLine(2, this.plugin.getClassManager().getStringManager().transform(e.getLine(2)));
            }
            if (e.getLine(3) != "") {
                e.setLine(3, this.plugin.getClassManager().getStringManager().transform(e.getLine(3)));
            }
        }
    }

    @EventHandler
    public void interactSign(PlayerInteractEvent e) {
        Sign s;
        GenesisShop shop;
        Block b;
        if (!this.signsEnabled) {
            return;
        }
        if (e.getClickedBlock() != null && e.getAction() == Action.RIGHT_CLICK_BLOCK && (b = e.getClickedBlock()).getType().name().contains("SIGN") && b.getState() instanceof Sign && (shop = this.getGenesisSign((s = (Sign)b.getState()).getLine(0))) != null) {
            e.setCancelled(true);
            if (e.getPlayer().hasPermission("Genesis.open") || e.getPlayer().hasPermission("Genesis.open.sign") || e.getPlayer().hasPermission("Genesis.open.sign." + shop.getShopName())) {
                this.plugin.getClassManager().getShops().openShop(e.getPlayer(), shop);
                return;
            }
            this.plugin.getClassManager().getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)e.getPlayer());
        }
    }

    @Generated
    public void setSignsEnabled(boolean signsEnabled) {
        this.signsEnabled = signsEnabled;
    }
}

