/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.listeners;

import java.util.WeakHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.folia.CrossScheduler;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.misc.MathTools;
import studio.magemonkey.genesis.misc.Misc;
import studio.magemonkey.genesis.misc.userinput.GenesisAnvilHolder;

public class InventoryListener
implements Listener {
    private final WeakHashMap<Player, Long> lastClicks;
    private final WeakHashMap<Player, Integer> clickspamCounts;
    private int clickDelay;
    private int clickspamDelay;
    private int clickspamWarnings;
    private int clickSpamForgetTime;
    private final Genesis plugin;

    public InventoryListener(Genesis plugin) {
        this.plugin = plugin;
        this.lastClicks = new WeakHashMap();
        this.clickspamCounts = new WeakHashMap();
    }

    public void init(int clickDelay, int clickspamDelay, int clickspamWarnings, int clickSpamForgetTime) {
        this.clickDelay = clickDelay;
        this.clickspamDelay = clickspamDelay;
        this.clickspamWarnings = clickspamWarnings;
        this.clickSpamForgetTime = clickSpamForgetTime;
    }

    @EventHandler
    public void closeShop(InventoryCloseEvent e) {
        if (!(e.getInventory().getHolder() instanceof GenesisShopHolder)) {
            return;
        }
        GenesisShopHolder holder = (GenesisShopHolder)e.getInventory().getHolder();
        if (e.getPlayer() instanceof Player) {
            Player p = (Player)e.getPlayer();
            this.plugin.getClassManager().getMessageHandler().sendMessage("Main.CloseShop", (CommandSender)p, null, (Player)e.getPlayer(), holder.getShop(), holder, null);
            CrossScheduler.run(() -> {
                if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory())) {
                    Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(10, this, null));
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void purchase(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof GenesisShopHolder)) {
            return;
        }
        boolean cancel = true;
        try {
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(event.getClickedInventory())) {
                switch (event.getAction()) {
                    case DROP_ALL_SLOT: 
                    case DROP_ONE_SLOT: 
                    case HOTBAR_MOVE_AND_READD: 
                    case HOTBAR_SWAP: 
                    case PICKUP_ALL: 
                    case PICKUP_HALF: 
                    case PICKUP_ONE: 
                    case PICKUP_SOME: 
                    case PLACE_ALL: 
                    case PLACE_ONE: 
                    case PLACE_SOME: 
                    case SWAP_WITH_CURSOR: {
                        cancel = false;
                        break;
                    }
                }
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (cancel) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
        GenesisShopHolder holder = (GenesisShopHolder)event.getInventory().getHolder();
        if (event.getWhoClicked() instanceof Player) {
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getClick() == ClickType.DOUBLE_CLICK) {
                return;
            }
            if (event.getCursor() == null) {
                return;
            }
            if (event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                return;
            }
            GenesisBuy buy = holder.getShopItem(event.getRawSlot());
            if (buy == null) {
                return;
            }
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
            Player p = (Player)event.getWhoClicked();
            ClickType clickType = event.getClick();
            GenesisShop shop = ((GenesisShopHolder)event.getInventory().getHolder()).getShop();
            if (!p.hasPermission("Genesis.bypass")) {
                if (this.lastClicks.containsKey(p)) {
                    long lastClick = this.lastClicks.get(p);
                    if (System.currentTimeMillis() < lastClick + (long)this.clickspamDelay) {
                        int clickspamCount = 0;
                        if (this.clickspamCounts.containsKey(p)) {
                            clickspamCount = this.clickspamCounts.get(p);
                        }
                        if (++clickspamCount > this.clickspamWarnings) {
                            p.kickPlayer(ClassManager.manager.getMessageHandler().get("Main.OffensiveClickSpamKick"));
                        } else {
                            double timeLeft = this.lastClicks.get(p) + (long)this.clickspamDelay - System.currentTimeMillis();
                            timeLeft = Math.max((double)0.1f, timeLeft / 1000.0);
                            ClassManager.manager.getMessageHandler().sendMessageDirect(ClassManager.manager.getStringManager().transform(ClassManager.manager.getMessageHandler().get("Main.OffensiveClickSpamWarning").replace("%time_left%", MathTools.displayNumber(timeLeft, 1)), buy, shop, holder, p), (CommandSender)p);
                        }
                        this.clickspamCounts.put(p, clickspamCount);
                        return;
                    }
                    if (System.currentTimeMillis() < lastClick + (long)this.clickDelay) {
                        double timeLeft = this.lastClicks.get(p) + (long)this.clickDelay - System.currentTimeMillis();
                        timeLeft = Math.max((double)0.1f, timeLeft / 1000.0);
                        ClassManager.manager.getMessageHandler().sendMessageDirect(ClassManager.manager.getStringManager().transform(ClassManager.manager.getMessageHandler().get("Main.ClickSpamWarning").replace("%time_left%", MathTools.displayNumber(timeLeft, 1)), buy, shop, holder, p), (CommandSender)p);
                        return;
                    }
                    if (this.clickspamCounts.containsKey(p) && lastClick + (long)this.clickSpamForgetTime < System.currentTimeMillis()) {
                        this.clickspamCounts.remove(p);
                    }
                }
                this.lastClicks.put(p, System.currentTimeMillis());
            }
            buy.click(p, shop, holder, clickType, event, this.plugin);
        }
    }

    @EventHandler
    public void drag(InventoryDragEvent event) {
        if (!(event.getInventory().getHolder() instanceof GenesisShopHolder)) {
            return;
        }
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
    }

    @EventHandler
    public void quit(PlayerQuitEvent event) {
        this.playerLeave((PlayerEvent)event);
    }

    @EventHandler
    public void kick(PlayerKickEvent event) {
        this.playerLeave((PlayerEvent)event);
    }

    public void playerLeave(PlayerEvent event) {
        if (this.lastClicks != null) {
            this.lastClicks.remove(event.getPlayer());
        }
        if (this.clickspamCounts != null) {
            this.clickspamCounts.remove(event.getPlayer());
        }
    }

    @EventHandler
    public void onAnvilEvent(InventoryClickEvent e) {
        if (e.getWhoClicked() instanceof Player) {
            Player p = (Player)e.getWhoClicked();
            if (e.getInventory().getHolder() instanceof GenesisAnvilHolder) {
                e.setResult(Event.Result.DENY);
                e.setCancelled(true);
                GenesisAnvilHolder holder = (GenesisAnvilHolder)e.getInventory().getHolder();
                String text = holder.getOutputText();
                if (text != null) {
                    holder.userClickedResult(p);
                }
            }
        }
    }
}

