/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.inbuiltaddons.logictypes;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.inbuiltaddons.logictypes.GenesisRewardPart;
import studio.magemonkey.genesis.managers.ClassManager;

public class GenesisRewardTypeAnd
extends GenesisRewardType {
    @Override
    public Object createObject(Object o, boolean forceFinalState) {
        ArrayList<GenesisRewardPart> rewardparts = new ArrayList<GenesisRewardPart>();
        ConfigurationSection rewards = (ConfigurationSection)o;
        int i = 1;
        while (rewards.contains("RewardType" + i)) {
            String rewardType = rewards.getString("RewardType" + i);
            Object rewardObject = rewards.get("Reward" + i);
            GenesisRewardType rewardT = GenesisRewardType.detectType(rewardType);
            if (rewardT == null) {
                ClassManager.manager.getBugFinder().severe("Invalid RewardType '" + rewardType + "' inside reward list of shopitem with rewardtype AND.");
                ClassManager.manager.getBugFinder().severe("Valid RewardTypes:");
                for (GenesisRewardType type : GenesisRewardType.values()) {
                    ClassManager.manager.getBugFinder().severe("-" + type.name());
                }
            } else {
                Object rewardO = rewardT.createObject(rewardObject, true);
                if (!rewardT.validityCheck("?", rewardO)) {
                    ClassManager.manager.getBugFinder().severe("Invalid Reward '" + String.valueOf(rewardO) + "' (RewardType= " + rewardType + ") inside reward list of shopitem with rewardtype AND.");
                } else {
                    rewardT.enableType();
                    GenesisRewardPart part = new GenesisRewardPart(rewardT, rewardO);
                    rewardparts.add(part);
                }
            }
            ++i;
        }
        return rewardparts;
    }

    @Override
    public boolean validityCheck(String itemName, Object o) {
        if (o != null) {
            return true;
        }
        ClassManager.manager.getBugFinder().severe("Was not able to create ShopItem " + itemName + "! The reward object needs to be a list of reward-blocks. Every rewardblock needs to contain reward and rewardtype.");
        return false;
    }

    @Override
    public void enableType() {
    }

    @Override
    public boolean canBuy(Player p, GenesisBuy buy, boolean messageIfNoSuccess, Object reward, ClickType clickType) {
        List rewardparts = (List)reward;
        for (GenesisRewardPart part : rewardparts) {
            if (part.getRewardType().canBuy(p, buy, messageIfNoSuccess, part.getReward(), clickType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void giveReward(Player p, GenesisBuy buy, Object reward, ClickType clickType) {
        List rewardparts = (List)reward;
        for (GenesisRewardPart part : rewardparts) {
            part.getRewardType().giveReward(p, buy, part.getReward(), clickType);
        }
    }

    @Override
    public String getDisplayReward(Player p, GenesisBuy buy, Object reward, ClickType clickType) {
        String sep = ClassManager.manager.getMessageHandler().get("Main.ListAndSeparator");
        Object s = "";
        List rewardparts = (List)reward;
        for (int i = 0; i < rewardparts.size(); ++i) {
            GenesisRewardPart part = (GenesisRewardPart)rewardparts.get(i);
            s = (String)s + part.getRewardType().getDisplayReward(p, buy, part.getReward(), clickType) + (i < rewardparts.size() - 1 ? sep : "");
        }
        return s;
    }

    @Override
    public String[] createNames() {
        return new String[]{"and"};
    }

    @Override
    public boolean mightNeedShopUpdate() {
        return true;
    }
}

