/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.inbuiltaddons.logictypes;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.inbuiltaddons.logictypes.GenesisPricePart;
import studio.magemonkey.genesis.managers.ClassManager;

public class GenesisPriceTypeOr
extends GenesisPriceType {
    @Override
    public Object createObject(Object o, boolean forceFinalState) {
        ArrayList<GenesisPricePart> parts = new ArrayList<GenesisPricePart>();
        ConfigurationSection prices = (ConfigurationSection)o;
        int i = 1;
        while (prices.contains("PriceType" + i)) {
            String priceType = prices.getString("PriceType" + i);
            Object priceObject = prices.get("Price" + i);
            GenesisPriceType priceT = GenesisPriceType.detectType(priceType);
            if (priceT == null) {
                ClassManager.manager.getBugFinder().severe("Invalid PriceType '" + priceType + "' inside price list of shopitem with pricetype AND.");
                ClassManager.manager.getBugFinder().severe("Valid PriceTypes:");
                for (GenesisPriceType type : GenesisPriceType.values()) {
                    ClassManager.manager.getBugFinder().severe("-" + type.name());
                }
            } else {
                priceT.enableType();
                Object priceO = priceT.createObject(priceObject, true);
                if (!priceT.validityCheck("?", priceO)) {
                    ClassManager.manager.getBugFinder().severe("Invalid Price '" + String.valueOf(priceO) + "' (PriceType= " + priceType + ") inside price list of shopitem with pricetype AND.");
                } else {
                    GenesisPricePart part = new GenesisPricePart(priceT, priceO);
                    parts.add(part);
                }
            }
            ++i;
        }
        return parts;
    }

    @Override
    public boolean validityCheck(String itemName, Object o) {
        if (o != null) {
            return true;
        }
        ClassManager.manager.getBugFinder().severe("Was not able to create ShopItem " + itemName + "! The price object needs to be a list of price-blocks. Every priceblock needs to contain price and pricetype.");
        return false;
    }

    @Override
    public void enableType() {
    }

    @Override
    public String[] createNames() {
        return new String[]{"or"};
    }

    @Override
    public boolean mightNeedShopUpdate() {
        return true;
    }

    @Override
    public boolean hasPrice(Player p, GenesisBuy buy, Object price, ClickType clickType, boolean messageOnFailure) {
        List priceparts = (List)price;
        for (GenesisPricePart part : priceparts) {
            if (!part.getPriceType().hasPrice(p, buy, part.getPrice(), clickType, false)) continue;
            return true;
        }
        if (messageOnFailure) {
            ClassManager.manager.getMessageHandler().sendMessage("NotEnough.Or", (CommandSender)p);
        }
        return false;
    }

    @Override
    public String takePrice(Player p, GenesisBuy buy, Object price, ClickType clickType) {
        List priceparts = (List)price;
        for (GenesisPricePart part : priceparts) {
            if (!part.getPriceType().hasPrice(p, buy, part.getPrice(), clickType, false)) continue;
            return part.getPriceType().takePrice(p, buy, part.getPrice(), clickType);
        }
        throw new RuntimeException("Unable to take price '" + String.valueOf(price) + "' of type AND: Player does not have the required price anymore");
    }

    @Override
    public String getDisplayPrice(Player p, GenesisBuy buy, Object price, ClickType clickType) {
        String sep = ClassManager.manager.getMessageHandler().get("Main.ListOrSeparator");
        Object s = "";
        List priceparts = (List)price;
        for (int i = 0; i < priceparts.size(); ++i) {
            GenesisPricePart part = (GenesisPricePart)priceparts.get(i);
            s = (String)s + part.getPriceType().getDisplayPrice(p, buy, part.getPrice(), clickType) + (i < priceparts.size() - 1 ? sep : "");
        }
        return s;
    }
}

