/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.inbuiltaddons.advancedshops;

import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisInputType;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.conditions.GenesisCondition;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.inbuiltaddons.advancedshops.ActionSet;

public class GenesisBuyAdvanced
extends GenesisBuy {
    private final Map<ClickType, ActionSet> actions;

    public GenesisBuyAdvanced(GenesisRewardType rewardT, GenesisPriceType priceT, Object reward, Object price, String msg, int location, String permission, String name, GenesisCondition condition, GenesisInputType inputType, String inputMessage, Map<ClickType, ActionSet> actions) {
        super(rewardT, priceT, reward, price, msg, location, permission, name, condition, inputType, inputMessage);
        this.actions = actions;
    }

    @Override
    public GenesisRewardType getRewardType(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getRewardType();
        }
        return super.getRewardType(clickType);
    }

    @Override
    public GenesisPriceType getPriceType(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getPriceType();
        }
        return super.getPriceType(clickType);
    }

    @Override
    public Object getReward(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getReward();
        }
        return super.getReward(clickType);
    }

    @Override
    public Object getPrice(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getPrice();
        }
        return super.getPrice(clickType);
    }

    @Override
    public String getMessage(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getMessage();
        }
        return super.getMessage(clickType);
    }

    @Override
    public GenesisInputType getInputType(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getInputType();
        }
        return super.getInputType(clickType);
    }

    @Override
    public String getInputText(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getInputText();
        }
        return super.getInputText(clickType);
    }

    @Override
    public boolean isExtraPermissionGroup(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).isExtraPermissionGroup();
        }
        return super.isExtraPermissionGroup(clickType);
    }

    @Override
    public String getExtraPermission(ClickType clickType) {
        if (this.actions != null && this.actions.containsKey(clickType)) {
            return this.actions.get(clickType).getExtraPermission();
        }
        return super.getExtraPermission(clickType);
    }

    @Override
    public String transformMessage(String msg, GenesisShop shop, Player p) {
        if ((msg = super.transformMessage(msg, shop, p)) == null) {
            return null;
        }
        if (msg.length() == 0) {
            return msg;
        }
        if (this.actions != null) {
            for (ClickType clickType : this.actions.keySet()) {
                boolean possiblyCustomizable;
                String priceMessage;
                ActionSet action = this.actions.get(clickType);
                String s = clickType.name().toLowerCase();
                String tp = "%price_" + s + "%";
                String tr = "%reward_" + s + "%";
                if (!msg.contains(tp) && !msg.contains(tr)) continue;
                String rewardMessage = action.getRewardType().isPlayerDependend(this, clickType) ? null : action.getRewardType().getDisplayReward(p, this, action.getReward(), clickType);
                String string = priceMessage = action.getPriceType().isPlayerDependend(this, clickType) ? null : action.getPriceType().getDisplayPrice(p, this, action.getPrice(), clickType);
                if (shop != null && !shop.isCustomizable()) {
                    boolean hasRewardVariable;
                    boolean hasPriceVariable = msg.contains(tp) && action.getPriceType().isPlayerDependend(this, clickType);
                    boolean bl = hasRewardVariable = msg.contains(tr) && action.getRewardType().isPlayerDependend(this, clickType);
                    if (hasPriceVariable || hasRewardVariable) {
                        shop.setCustomizable(true);
                        shop.setDisplaying(true);
                    }
                }
                boolean bl = possiblyCustomizable = shop == null || shop.isCustomizable();
                if (possiblyCustomizable && p != null) {
                    rewardMessage = action.getRewardType().getDisplayReward(p, this, action.getReward(), clickType);
                    priceMessage = action.getPriceType().getDisplayPrice(p, this, action.getPrice(), clickType);
                }
                if (priceMessage != null && !priceMessage.isEmpty()) {
                    msg = msg.replace(tp, priceMessage);
                }
                if (rewardMessage == null || rewardMessage.isEmpty()) continue;
                msg = msg.replace(tr, rewardMessage);
            }
        }
        return msg;
    }
}

