/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.folia;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.foliabridge.FoliaBridge;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.managers.ClassManager;

public class CrossScheduler {
    private static final Genesis plugin = ClassManager.manager.getPlugin();
    private static final boolean isFolia = Bukkit.getName().contains("Folia");

    public static boolean isFolia() {
        return isFolia;
    }

    public static void run(Runnable runnable) {
        if (isFolia) {
            FoliaBridge.execute((Plugin)plugin, runnable);
        } else {
            Bukkit.getScheduler().runTask((Plugin)plugin, runnable);
        }
    }

    public static void runAsync(Runnable runnable) {
        if (isFolia) {
            FoliaBridge.execute((Plugin)plugin, runnable);
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, runnable);
        }
    }

    public static void runTaskLater(Runnable runnable, long delayTicks) {
        if (isFolia) {
            FoliaBridge.runDelayed((Plugin)plugin, runnable, delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, runnable, delayTicks);
        }
    }

    public static void runTaskLaterAsync(Runnable runnable, long delay) {
        if (isFolia) {
            FoliaBridge.runDelayed((Plugin)plugin, runnable, delay);
        } else {
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, runnable, delay);
        }
    }

    public static void runTaskTimer(Runnable runnable, long delay, long period) {
        if (isFolia) {
            FoliaBridge.runAtFixedRate((Plugin)plugin, runnable, delay < 1L ? 1L : delay, period);
        } else {
            Bukkit.getScheduler().runTaskTimer((Plugin)plugin, runnable, delay, period);
        }
    }

    public static void runTaskTimerAsync(Runnable runnable, long delay, long period) {
        if (isFolia) {
            FoliaBridge.runAtFixedRate((Plugin)plugin, runnable, delay < 1L ? 1L : delay, period);
        } else {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)plugin, runnable, delay, period);
        }
    }

    public static <T> Future<T> callSyncMethod(Callable<T> task) {
        if (isFolia) {
            ClassManager.manager.getBugFinder().warn("Folia does not support cancelling tasks by ID");
            CrossScheduler.runTaskLater(() -> {
                try {
                    task.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, 1L);
            return new CompletableFuture();
        }
        return Bukkit.getScheduler().callSyncMethod((Plugin)plugin, task);
    }

    public static void cancelTask(int taskId) {
        if (isFolia) {
            ClassManager.manager.getBugFinder().warn("Folia does not support cancelling tasks by ID");
        } else {
            Bukkit.getScheduler().cancelTask(taskId);
        }
    }

    public static void cancelTasks(Plugin plugin) {
        if (isFolia) {
            FoliaBridge.cancelTasks((Plugin)CrossScheduler.plugin, plugin);
        } else {
            Bukkit.getScheduler().cancelTasks(plugin);
        }
    }
}

