/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core.rewards;

import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.misc.InputReader;

public class GenesisRewardTypeShop
extends GenesisRewardType {
    @Override
    public Object createObject(Object o, boolean forceFinalState) {
        return InputReader.readString(o, true);
    }

    @Override
    public boolean validityCheck(String itemName, Object o) {
        if (o != null) {
            return true;
        }
        ClassManager.manager.getBugFinder().severe("Was not able to create ShopItem " + itemName + "! The reward object needs to be the name of a shop (a single text line).");
        return false;
    }

    @Override
    public void enableType() {
    }

    @Override
    public boolean canBuy(Player p, GenesisBuy buy, boolean messageIfNoSuccess, Object reward, ClickType clickType) {
        return true;
    }

    @Override
    public void giveReward(Player p, GenesisBuy buy, Object reward, ClickType clickType) {
        String shopName = (String)reward;
        if (shopName == null || shopName == "" || shopName.length() < 1) {
            p.closeInventory();
        } else {
            ClassManager.manager.getShops().openShop(p, shopName);
        }
    }

    @Override
    public String getDisplayReward(Player p, GenesisBuy buy, Object reward, ClickType clickType) {
        String shopName = (String)reward;
        if (shopName == null || shopName == "" || shopName.length() < 1) {
            return ClassManager.manager.getMessageHandler().get("Display.Close");
        }
        return ClassManager.manager.getMessageHandler().get("Display.Shop").replace("%shop%", shopName);
    }

    @Override
    public String[] createNames() {
        return new String[]{"shop"};
    }

    @Override
    public boolean logTransaction() {
        return false;
    }

    @Override
    public boolean mightNeedShopUpdate() {
        return false;
    }

    @Override
    public boolean isActualReward() {
        return false;
    }
}

