/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core.rewards;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeBungeeCordCommand;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeBungeeCordServer;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeClose;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeCommand;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeCustom;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeEnchantment;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeExp;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeItem;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeItemAll;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeMessage;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeMoney;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeNothing;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypePermission;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypePlayerCommand;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypePlayerCommandOp;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypePoints;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeShop;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeShopPage;
import studio.magemonkey.genesis.core.rewards.GenesisRewardTypeTeleport;
import studio.magemonkey.genesis.managers.ClassManager;

public abstract class GenesisRewardType {
    public static GenesisRewardType BungeeCordCommand;
    public static GenesisRewardType BungeeCordServer;
    public static GenesisRewardType Close;
    public static GenesisRewardType Command;
    public static GenesisRewardType Custom;
    public static GenesisRewardType Enchantment;
    public static GenesisRewardType Exp;
    public static GenesisRewardType Item;
    public static GenesisRewardType ItemAll;
    public static GenesisRewardType Message;
    public static GenesisRewardType Money;
    public static GenesisRewardType Nothing;
    public static GenesisRewardType Permission;
    public static GenesisRewardType PlayerCommand;
    public static GenesisRewardType PlayerCommandOp;
    public static GenesisRewardType Points;
    public static GenesisRewardType Shop;
    public static GenesisRewardType ShopBack;
    public static GenesisRewardType ShopPage;
    public static GenesisRewardType Teleport;
    private static List<GenesisRewardType> types;
    private String[] names = this.createNames();

    public static void loadTypes() {
        types = new ArrayList<GenesisRewardType>();
        BungeeCordCommand = GenesisRewardType.registerType(new GenesisRewardTypeBungeeCordCommand());
        BungeeCordServer = GenesisRewardType.registerType(new GenesisRewardTypeBungeeCordServer());
        Close = GenesisRewardType.registerType(new GenesisRewardTypeClose());
        Custom = GenesisRewardType.registerType(new GenesisRewardTypeCustom());
        Command = GenesisRewardType.registerType(new GenesisRewardTypeCommand());
        Enchantment = GenesisRewardType.registerType(new GenesisRewardTypeEnchantment());
        Exp = GenesisRewardType.registerType(new GenesisRewardTypeExp());
        Item = GenesisRewardType.registerType(new GenesisRewardTypeItem());
        ItemAll = GenesisRewardType.registerType(new GenesisRewardTypeItemAll());
        Message = GenesisRewardType.registerType(new GenesisRewardTypeMessage());
        Money = GenesisRewardType.registerType(new GenesisRewardTypeMoney());
        Nothing = GenesisRewardType.registerType(new GenesisRewardTypeNothing());
        Permission = GenesisRewardType.registerType(new GenesisRewardTypePermission());
        PlayerCommand = GenesisRewardType.registerType(new GenesisRewardTypePlayerCommand());
        PlayerCommandOp = GenesisRewardType.registerType(new GenesisRewardTypePlayerCommandOp());
        Points = GenesisRewardType.registerType(new GenesisRewardTypePoints());
        Shop = GenesisRewardType.registerType(new GenesisRewardTypeShop());
        ShopPage = GenesisRewardType.registerType(new GenesisRewardTypeShopPage());
        Teleport = GenesisRewardType.registerType(new GenesisRewardTypeTeleport());
    }

    public static GenesisRewardType registerType(GenesisRewardType type) {
        types.add(type);
        return type;
    }

    public static GenesisRewardType detectType(String s) {
        if (s != null) {
            for (GenesisRewardType type : types) {
                if (!type.isType(s)) continue;
                return type;
            }
        }
        return Nothing;
    }

    public static List<GenesisRewardType> values() {
        return types;
    }

    public boolean isType(String s) {
        if (this.names != null) {
            for (String name : this.names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void register() {
        GenesisRewardType.registerType(this);
    }

    public String name() {
        return this.names[0].toUpperCase();
    }

    public void updateNames() {
        this.names = this.createNames();
    }

    public abstract Object createObject(Object var1, boolean var2);

    public abstract boolean validityCheck(String var1, Object var2);

    public abstract void enableType();

    public abstract boolean canBuy(Player var1, GenesisBuy var2, boolean var3, Object var4, ClickType var5);

    public abstract void giveReward(Player var1, GenesisBuy var2, Object var3, ClickType var4);

    public abstract String getDisplayReward(Player var1, GenesisBuy var2, Object var3, ClickType var4);

    public abstract String[] createNames();

    public boolean logTransaction() {
        return true;
    }

    public boolean isPlayerDependend(GenesisBuy buy, ClickType clickType) {
        return this.supportsMultipliers() && ClassManager.manager.getMultiplierHandler().hasMultipliers() || buy.getRewardType(clickType) == ItemAll && ClassManager.manager.getSettings().getItemAllShowFinalReward();
    }

    public boolean supportsMultipliers() {
        return false;
    }

    public boolean isActualReward() {
        return true;
    }

    public boolean allowAsync() {
        return false;
    }

    public boolean overridesPrice() {
        return false;
    }

    public String getPriceReturnMessage(Player p, GenesisBuy buy, Object price, ClickType clickType) {
        return null;
    }

    public abstract boolean mightNeedShopUpdate();
}

