/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core.prices;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.prices.GenesisPriceTypeExp;
import studio.magemonkey.genesis.core.prices.GenesisPriceTypeItem;
import studio.magemonkey.genesis.core.prices.GenesisPriceTypeItemAll;
import studio.magemonkey.genesis.core.prices.GenesisPriceTypeMoney;
import studio.magemonkey.genesis.core.prices.GenesisPriceTypeNothing;
import studio.magemonkey.genesis.core.prices.GenesisPriceTypePoints;
import studio.magemonkey.genesis.managers.ClassManager;

public abstract class GenesisPriceType {
    public static GenesisPriceType Item;
    public static GenesisPriceType ItemAll;
    public static GenesisPriceType Money;
    public static GenesisPriceType Nothing;
    public static GenesisPriceType Points;
    public static GenesisPriceType Exp;
    public static GenesisPriceType ThirdCurrencyVariable;
    private static List<GenesisPriceType> types;
    private String[] names = this.createNames();

    public static void loadTypes() {
        types = new ArrayList<GenesisPriceType>();
        Item = GenesisPriceType.registerType(new GenesisPriceTypeItem());
        ItemAll = GenesisPriceType.registerType(new GenesisPriceTypeItemAll());
        Money = GenesisPriceType.registerType(new GenesisPriceTypeMoney());
        Nothing = GenesisPriceType.registerType(new GenesisPriceTypeNothing());
        Points = GenesisPriceType.registerType(new GenesisPriceTypePoints());
        Exp = GenesisPriceType.registerType(new GenesisPriceTypeExp());
    }

    public static GenesisPriceType registerType(GenesisPriceType type) {
        types.add(type);
        return type;
    }

    public static GenesisPriceType detectType(String s) {
        for (GenesisPriceType type : types) {
            if (!type.isType(s)) continue;
            return type;
        }
        return Nothing;
    }

    public static List<GenesisPriceType> values() {
        return types;
    }

    public boolean isType(String s) {
        if (this.names != null) {
            for (String name : this.names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void register() {
        GenesisPriceType.registerType(this);
    }

    public String name() {
        return this.names[0].toUpperCase();
    }

    public void updateNames() {
        this.names = this.createNames();
    }

    public abstract Object createObject(Object var1, boolean var2);

    public abstract boolean validityCheck(String var1, Object var2);

    public abstract void enableType();

    public abstract boolean hasPrice(Player var1, GenesisBuy var2, Object var3, ClickType var4, boolean var5);

    public abstract String takePrice(Player var1, GenesisBuy var2, Object var3, ClickType var4);

    public abstract String getDisplayPrice(Player var1, GenesisBuy var2, Object var3, ClickType var4);

    public abstract String[] createNames();

    public abstract boolean mightNeedShopUpdate();

    public boolean isPlayerDependend(GenesisBuy buy, ClickType clickType) {
        return this.supportsMultipliers() && ClassManager.manager.getMultiplierHandler().hasMultipliers();
    }

    public boolean overridesReward() {
        return false;
    }

    public boolean supportsMultipliers() {
        return false;
    }
}

