/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core.conditions;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.core.conditions.GenesisConditionType;
import studio.magemonkey.genesis.managers.ClassManager;

public class GenesisConditionTypePlaceholderMatch
extends GenesisConditionType {
    public boolean matches(Player p, String singleCondition, String placeholder) {
        placeholder = ClassManager.manager.getStringManager().transform(placeholder, p);
        singleCondition = ClassManager.manager.getStringManager().transform(singleCondition, p);
        return ChatColor.stripColor((String)placeholder).trim().equalsIgnoreCase(ChatColor.stripColor((String)singleCondition.trim()));
    }

    @Override
    public boolean dependsOnPlayer() {
        return true;
    }

    @Override
    public String[] createNames() {
        return new String[]{"placeholdermatch", "placeholder"};
    }

    @Override
    public void enableType() {
    }

    @Override
    public boolean meetsCondition(GenesisShopHolder holder, GenesisBuy shopItem, Player p, String conditionType, String condition) {
        String[] parts = condition.split(":", 2);
        if (parts.length < 2) {
            ClassManager.manager.getBugFinder().warn("Unable to read placeholdermatch condition " + conditionType + ":" + condition + " of shopitem " + shopItem.getName() + ". It should look like following: '<Placeholder text>:<match/dontmatch>:<text>'.");
            return false;
        }
        if (parts[0].equalsIgnoreCase("match")) {
            return this.isCorrect(p, true, parts[1], conditionType);
        }
        if (parts[0].equalsIgnoreCase("dontmatch")) {
            return this.isCorrect(p, false, parts[1], conditionType);
        }
        return false;
    }

    private boolean isCorrect(Player p, boolean hasToMatch, String condition, String placeholder) {
        for (String singleCondition : condition.split(",")) {
            if (this.matches(p, singleCondition, placeholder) != hasToMatch) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] showStructure() {
        return new String[]{"[string]:match:[string]", "[string]:dontmatch:[string]"};
    }
}

