/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core;

import java.io.File;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.api.InventoryUtil;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.FileHandler;
import studio.magemonkey.genesis.managers.config.GenesisConfigShop;
import studio.magemonkey.genesis.settings.Settings;

public class GenesisShops {
    private final HashMap<Integer, GenesisShop> shops = new HashMap();
    private final HashMap<String, Integer> shopsIds = new HashMap();
    private int id = 0;

    public GenesisShops(Genesis plugin, Settings settings) {
        File folder = new File(plugin.getDataFolder().getAbsolutePath() + File.separator + "shops" + File.separator);
        new FileHandler().exportShops(plugin);
        boolean enableShopCommands = this.loadShops(folder, settings, "");
        ClassManager.manager.getSettings().setShopCommandsEnabled(enableShopCommands);
        Genesis.log("Loaded " + this.shops.size() + " Shops!");
    }

    private boolean loadShops(File folder, Settings settings, String parentPath) {
        boolean enableShopCommands = false;
        for (File f : folder.listFiles()) {
            GenesisShop shop;
            if (f == null) continue;
            if (f.isDirectory()) {
                if (!settings.getLoadSubFoldersEnabled() || !this.loadShops(f, settings, parentPath + f.getName() + File.separator)) continue;
                enableShopCommands = true;
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".yml") || (shop = this.loadShop(f, parentPath)).getCommands() == null) continue;
            enableShopCommands = true;
        }
        return enableShopCommands;
    }

    public void addShop(GenesisShop shop) {
        this.shops.put(shop.getShopId(), shop);
        if (this.shopsIds.containsKey(shop.getShopName().toLowerCase())) {
            ClassManager.manager.getBugFinder().warn("Two Shops with the same Name (" + shop.getShopName().toLowerCase() + ") are loaded. When opening a Shop via Name, only one of this Shops will be opened!");
        }
        this.shopsIds.put(shop.getShopName().toLowerCase(), shop.getShopId());
    }

    public GenesisShop loadShop(File f, String parentPath) {
        String name = parentPath + f.getName();
        GenesisConfigShop shop = new GenesisConfigShop(this.createId(), name, this);
        this.addShop(shop);
        return shop;
    }

    public void unloadShop(GenesisShop shop) {
        int id = this.getShopId(shop.getShopName());
        this.shopsIds.remove(shop.getShopName());
        this.shops.remove(id);
        shop.close();
    }

    public GenesisShop reloadShop(GenesisShop shop) {
        GenesisConfigShop reloadedShop = new GenesisConfigShop(shop.getShopId(), ((GenesisConfigShop)shop).getYmlName(), this);
        this.unloadShop(shop);
        this.addShop(reloadedShop);
        return reloadedShop;
    }

    public void openShop(Player p, String name) {
        if (!this.isShop(name)) {
            ClassManager.manager.getMessageHandler().sendMessage("Main.ShopNotExisting", (CommandSender)p);
            return;
        }
        this.openShop(p, this.getShopFast(name));
    }

    public void openShop(Player p, GenesisShop shop) {
        GenesisShopHolder holder;
        GenesisShopHolder oldShopHolder;
        int page = 0;
        boolean rememberCurrentShop = true;
        InventoryView view = p.getOpenInventory();
        Inventory top = InventoryUtil.getTopInventory(view);
        if (top.getHolder() instanceof GenesisShopHolder && (oldShopHolder = (holder = (GenesisShopHolder)top.getHolder()).getPreviousShopHolder()) != null && oldShopHolder.getShop() == shop) {
            page = oldShopHolder.getPage();
            rememberCurrentShop = false;
        }
        shop.openInventory(p, page, rememberCurrentShop);
    }

    public GenesisShop getShop(String name) {
        return this.getShop(this.getShopId(name));
    }

    public GenesisShop getShopFast(String name) {
        return this.getShopFast(this.getShopId(name));
    }

    public GenesisShop getShopByCommand(String playerCommand) {
        if (playerCommand != null && playerCommand.length() > 0) {
            for (GenesisShop shop : this.shops.values()) {
                String[] commands = shop.getCommands();
                if (commands == null) continue;
                for (String command : commands) {
                    if (!command.equalsIgnoreCase(playerCommand)) continue;
                    return shop;
                }
            }
        }
        return null;
    }

    public GenesisShop getShop(int id) {
        return this.shops.getOrDefault(id, null);
    }

    public GenesisShop getShopFast(int id) {
        return this.shops.get(id);
    }

    public int getShopId(String name) {
        if (!this.shopsIds.containsKey(name = name.toLowerCase())) {
            return -1;
        }
        return this.shopsIds.get(name);
    }

    public boolean isShop(String name) {
        return this.shopsIds.containsKey(name);
    }

    public boolean isShop(int id) {
        return this.shops.containsKey(id);
    }

    public HashMap<Integer, GenesisShop> getShops() {
        return this.shops;
    }

    public HashMap<String, Integer> getShopIds() {
        return this.shopsIds;
    }

    public int createId() {
        ++this.id;
        return this.id;
    }

    public void refreshShops(boolean serverPinging) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            Inventory openInventory;
            GenesisShopHolder h;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || !(h = (GenesisShopHolder)(openInventory = InventoryUtil.getTopInventory(p.getOpenInventory())).getHolder()).getShop().isCustomizable() || serverPinging || ClassManager.manager.getSettings().getServerPingingEnabled(true) && ClassManager.manager.getServerPingingManager().containsServerpinging(h.getShop())) continue;
            h.getShop().updateInventory(openInventory, h, p, ClassManager.manager, h.getPage(), h.getHighestPage(), true);
        }
    }
}

