/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.api.InventoryUtil;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.events.GenesisChoosePageLayoutEvent;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.features.PageLayoutHandler;
import studio.magemonkey.genesis.misc.Misc;

public abstract class GenesisShop {
    public static final int ROWS_LIMIT_CURRENT = ClassManager.manager.getPageLayoutHandler().getMaxRows();
    public static final int ROWS_LIMIT_TOTAL = 6;
    public static final int ROW_ITEMS = 9;
    private String shopName = "Genesis";
    private String signText = "[Genesis]";
    private String displayName;
    private String[] commands;
    private boolean needPermToCreateSign = true;
    private boolean customizable = !ClassManager.manager.getPageLayoutHandler().showIfMultiplePagesOnly();
    private boolean displaying = false;
    private int inventorySize = 9;
    private int manualInventoryRows;
    private final int shopId;
    private int highestPage;
    private final Set<GenesisBuy> items = new LinkedHashSet<GenesisBuy>();

    public GenesisShop(int shopId, String shopName, String signText, boolean needPermToCreateSign, Genesis plugin, String displayName, int manualInventoryRows, String[] commands) {
        this.shopId = shopId;
        this.shopName = shopName;
        this.signText = signText;
        this.manualInventoryRows = manualInventoryRows;
        this.needPermToCreateSign = needPermToCreateSign;
        this.setCommands(commands);
        this.setDisplayName(displayName);
    }

    public GenesisShop(int shopId) {
        this.shopId = shopId;
    }

    public void setDisplayName(String displayName) {
        if (displayName != null) {
            this.displayName = ClassManager.manager.getStringManager().transform(displayName, null, this, null, null);
            if (ClassManager.manager.getStringManager().checkStringForFeatures(this, null, null, this.displayName)) {
                this.customizable = true;
                this.displaying = true;
            }
        } else {
            this.displayName = this.shopName;
        }
    }

    public String getValidDisplayName(Player p, GenesisShopHolder holder) {
        return ClassManager.manager.getStringManager().transform(this.displayName, null, this, holder, p);
    }

    public boolean needPermToCreateSign() {
        return this.needPermToCreateSign;
    }

    public boolean isCustomizable() {
        return this.customizable;
    }

    public boolean isDisplaying() {
        return this.displaying;
    }

    public GenesisBuy getItem(String name) {
        for (GenesisBuy buy : this.items) {
            if (!buy.getName().equalsIgnoreCase(name)) continue;
            return buy;
        }
        for (GenesisBuy buy : this.items) {
            if (!buy.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            return buy;
        }
        return null;
    }

    public void addShopItem(GenesisBuy buy, ItemStack menuItem, ClassManager manager) {
        buy.updateShop(this, menuItem, manager, true);
    }

    public void removeShopItem(GenesisBuy buy) {
        this.items.remove(buy);
    }

    public Inventory createInventory(Player p, ClassManager manager, int page, int highestPage, GenesisShopHolder oldShopHolder) {
        return manager.getShopCustomizer().createInventory(this, this.items, p, manager, page, highestPage, oldShopHolder);
    }

    public void updateInventory(Inventory i, GenesisShopHolder holder, Player p, ClassManager manager, int page, int highestPage, boolean autoRefresh) {
        if (holder.getPage() != page) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(11, this, null));
        }
        holder.setPage(page);
        holder.setHighestPage(highestPage);
        if (ClassManager.manager.getStringManager().checkStringForFeatures(this, null, null, this.getDisplayName()) & !this.getValidDisplayName(p, holder).equals(InventoryUtil.getTitle(p.getOpenInventory())) & !autoRefresh) {
            Inventory created = manager.getShopCustomizer().createInventory(this, this.items, p, manager, page, highestPage, holder.getPreviousShopHolder());
            p.openInventory(created);
            return;
        }
        Inventory inventory = manager.getShopCustomizer().createInventory(this, this.items, p, manager, i, page, highestPage);
        if (inventory != i) {
            p.openInventory(inventory);
        }
    }

    public void loadInventorySize() {
        PageLayoutHandler layout = ClassManager.manager.getPageLayoutHandler();
        GenesisChoosePageLayoutEvent event = new GenesisChoosePageLayoutEvent(this, this.getShopName(), layout);
        Bukkit.getPluginManager().callEvent((Event)event);
        layout = event.getLayout();
        if (!layout.showIfMultiplePagesOnly()) {
            this.inventorySize = 9 * layout.getMaxRows();
            return;
        }
        HashSet<Integer> usedSlots = new HashSet<Integer>();
        int highest = 0;
        int differentSlotsAmount = 0;
        for (GenesisBuy b : this.items) {
            if (b == null) continue;
            if (b.getInventoryLocation() == -1) {
                ++differentSlotsAmount;
            } else {
                usedSlots.add(b.getInventoryLocation());
            }
            if (b.getInventoryLocation() <= highest) continue;
            highest = b.getInventoryLocation();
        }
        this.inventorySize = this.getInventorySize(Math.max(highest, (differentSlotsAmount += usedSlots.size()) - 1));
    }

    @Deprecated
    public int getInventorySize(int i) {
        int rest;
        if ((rest = ++i % 9) > 0) {
            i += 9 - i % 9;
        }
        int maxSlotsPerPage = ROWS_LIMIT_CURRENT * 9;
        this.highestPage = !ClassManager.manager.getPageLayoutHandler().showIfMultiplePagesOnly() || i > maxSlotsPerPage ? i / (ClassManager.manager.getPageLayoutHandler().getReservedSlotsStart() - 1) : 0;
        return Math.min(maxSlotsPerPage, Math.max(i, 9 * this.manualInventoryRows));
    }

    public void openInventory(Player p) {
        this.openInventory(p, 0, true);
    }

    public void openInventory(Player p, boolean rememberCurrentShop) {
        this.openInventory(p, 0, rememberCurrentShop);
    }

    public void openInventory(Player p, int page, boolean rememberCurrentShop) {
        InventoryView openInventory;
        Inventory top;
        GenesisShopHolder oldShopHolder = null;
        if (rememberCurrentShop && (top = InventoryUtil.getTopInventory(openInventory = p.getOpenInventory())).getHolder() instanceof GenesisShopHolder) {
            oldShopHolder = (GenesisShopHolder)top.getHolder();
        }
        ClassManager.manager.getMessageHandler().sendMessage("Main.OpenShop", (CommandSender)p, null, p, this, null, null);
        if (ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory())) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(12, this, null));
        } else {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(9, this, null));
        }
        p.openInventory(this.createInventory(p, ClassManager.manager, page, this.highestPage, oldShopHolder));
        ClassManager.manager.getPlayerDataHandler().openedShop(p, this);
    }

    public void close() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            GenesisShopHolder holder;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || (holder = (GenesisShopHolder)InventoryUtil.getTopInventory(p.getOpenInventory()).getHolder()).getShop() != this) continue;
            p.closeInventory();
        }
    }

    public boolean isBeingAccessed(Player exclusion) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            GenesisShopHolder holder;
            if (!ClassManager.manager.getPlugin().getAPI().isValidShop(p.getOpenInventory()) || (holder = (GenesisShopHolder)InventoryUtil.getTopInventory(p.getOpenInventory()).getHolder()).getShop() != this || p == exclusion) continue;
            return true;
        }
        return false;
    }

    public void finishedAddingItems() {
        this.loadInventorySize();
    }

    public abstract void reloadShop();

    @Generated
    public String getShopName() {
        return this.shopName;
    }

    @Generated
    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    @Generated
    public String getSignText() {
        return this.signText;
    }

    @Generated
    public void setSignText(String signText) {
        this.signText = signText;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String[] getCommands() {
        return this.commands;
    }

    @Generated
    public void setCommands(String[] commands) {
        this.commands = commands;
    }

    @Generated
    public void setNeedPermToCreateSign(boolean needPermToCreateSign) {
        this.needPermToCreateSign = needPermToCreateSign;
    }

    @Generated
    public void setCustomizable(boolean customizable) {
        this.customizable = customizable;
    }

    @Generated
    public void setDisplaying(boolean displaying) {
        this.displaying = displaying;
    }

    @Generated
    public int getInventorySize() {
        return this.inventorySize;
    }

    @Generated
    public int getManualInventoryRows() {
        return this.manualInventoryRows;
    }

    @Generated
    public void setManualInventoryRows(int manualInventoryRows) {
        this.manualInventoryRows = manualInventoryRows;
    }

    @Generated
    public int getShopId() {
        return this.shopId;
    }

    @Generated
    public Set<GenesisBuy> getItems() {
        return this.items;
    }
}

