/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.core;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.core.GenesisInputType;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.core.conditions.GenesisCondition;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.events.GenesisPlayerPurchaseEvent;
import studio.magemonkey.genesis.events.GenesisPlayerPurchasedEvent;
import studio.magemonkey.genesis.folia.CrossScheduler;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.GenesisConfigShop;
import studio.magemonkey.genesis.misc.MathTools;
import studio.magemonkey.genesis.misc.Misc;
import studio.magemonkey.genesis.misc.ShopItemPurchaseTask;

public class GenesisBuy {
    private GenesisShop shop;
    private HashMap<Plugin, Object> specialInformation;
    private boolean fixItem;
    private ItemStack item;
    private final String name;
    private GenesisInputType inputType;
    private String inputText;
    private final GenesisRewardType rewardT;
    private final GenesisPriceType priceT;
    private final Object reward;
    private final Object price;
    private String priceMessage = "";
    private String rewardMessage = "";
    private GenesisCondition condition;
    private String permission;
    private boolean permIsGroup = false;
    private final String msg;
    private int location;

    public GenesisBuy(GenesisRewardType rewardT, GenesisPriceType priceT, Object reward, Object price, String msg, int location, String permission, String name, GenesisCondition condition, GenesisInputType inputType, String inputText) {
        this(rewardT, priceT, reward, price, msg, location, permission, name);
        this.condition = condition;
        this.inputType = inputType;
        this.inputText = ClassManager.manager.getStringManager().transform(inputText, this, null, null, null);
    }

    public GenesisBuy(GenesisRewardType rewardT, GenesisPriceType priceT, Object reward, Object price, String msg, int location, String permission, String name) {
        this.priceT = priceT;
        this.rewardT = rewardT;
        if (permission != null && !permission.isEmpty()) {
            this.permission = permission;
            if (permission.startsWith("[") && permission.endsWith("]") && permission.length() > 2) {
                String group = permission.substring(1, permission.length() - 1);
                ClassManager.manager.getSettings().setVaultEnabled(true);
                this.permission = group;
                this.permIsGroup = true;
            }
        }
        this.reward = reward;
        this.price = price;
        this.name = name;
        this.msg = ClassManager.manager.getStringManager().transform(msg, this, null, null, null);
        this.location = location;
    }

    public GenesisRewardType getRewardType(ClickType clickType) {
        return this.rewardT;
    }

    public GenesisPriceType getPriceType(ClickType clickType) {
        return this.priceT;
    }

    public Object getReward(ClickType clickType) {
        return this.reward;
    }

    public Object getPrice(ClickType clickType) {
        return this.price;
    }

    public String getMessage(ClickType clickType) {
        return this.msg;
    }

    public GenesisInputType getInputType(ClickType clickType) {
        return this.inputType;
    }

    public String getInputText(ClickType clickType) {
        return this.inputText;
    }

    public int getInventoryLocation() {
        return this.location;
    }

    @Deprecated
    public void setInventoryLocation(int i) {
        this.location = i;
    }

    public boolean isItemFix() {
        return this.fixItem;
    }

    public boolean meetsCondition(GenesisShopHolder holder, Player p) {
        if (this.condition != null) {
            return this.condition.meetsCondition(holder, this, p);
        }
        return true;
    }

    public boolean containsConditions() {
        return this.condition != null;
    }

    public ConfigurationSection getConfigurationSection(GenesisConfigShop shop) {
        return shop.getConfig().getConfigurationSection("shop").getConfigurationSection(this.name);
    }

    public boolean hasPermission(Player p, boolean msg, ClickType clickType) {
        if (!this.isExtraPermissionExisting(clickType)) {
            return true;
        }
        String permission = this.getExtraPermission(clickType);
        if (this.isExtraPermissionGroup(clickType)) {
            boolean noGroup = true;
            for (String group : ClassManager.manager.getVaultHandler().getPermission().getPlayerGroups(p)) {
                noGroup = false;
                if (!group.equalsIgnoreCase(permission)) continue;
                return true;
            }
            if (noGroup && permission.equalsIgnoreCase("default")) {
                return true;
            }
            if (msg) {
                ClassManager.manager.getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)p);
            }
            return false;
        }
        if (p.hasPermission(permission)) {
            return true;
        }
        if (msg) {
            ClassManager.manager.getMessageHandler().sendMessage("Main.NoPermission", (CommandSender)p);
        }
        return false;
    }

    public boolean isExtraPermissionExisting(ClickType clickType) {
        String permission = this.getExtraPermission(clickType);
        if (permission == null) {
            return false;
        }
        return !permission.equalsIgnoreCase("");
    }

    public boolean isExtraPermissionGroup(ClickType clickType) {
        return this.permIsGroup;
    }

    public String getExtraPermission(ClickType clickType) {
        return this.permission;
    }

    public Object readSpecialInformation(Plugin plugin) {
        if (this.specialInformation != null) {
            return this.specialInformation.get(plugin);
        }
        return null;
    }

    public String transformMessage(String msg, GenesisShop shop, Player p) {
        this.rewardMessage = "";
        this.priceMessage = "";
        if (msg == null || msg.isEmpty()) {
            return msg;
        }
        if (p == null) {
            if (msg.contains("%input_text%")) {
                this.inputType = GenesisInputType.TEXT;
            } else if (msg.contains("%input_player%")) {
                this.inputType = GenesisInputType.PLAYER;
            }
            if (this.inputType != null && shop != null) {
                shop.setCustomizable(true);
                shop.setDisplaying(true);
            }
        }
        if (msg.contains("%price%") || msg.contains("%reward%")) {
            boolean possiblyCustomizable;
            this.rewardMessage = this.rewardT.isPlayerDependend(this, null) ? null : this.rewardT.getDisplayReward(p, this, this.reward, null);
            String string = this.priceMessage = this.priceT.isPlayerDependend(this, null) ? null : this.priceT.getDisplayPrice(p, this, this.price, null);
            if (shop != null && !shop.isCustomizable()) {
                boolean hasRewardVariable;
                boolean hasPriceVariable = msg.contains("%price%") && this.priceT.isPlayerDependend(this, null);
                boolean bl = hasRewardVariable = msg.contains("%reward%") && this.rewardT.isPlayerDependend(this, null);
                if (hasPriceVariable || hasRewardVariable) {
                    shop.setCustomizable(true);
                    shop.setDisplaying(true);
                }
            }
            boolean bl = possiblyCustomizable = shop == null || shop.isCustomizable();
            if (possiblyCustomizable && p != null) {
                this.rewardMessage = this.rewardT.getDisplayReward(p, this, this.reward, null);
                this.priceMessage = this.priceT.getDisplayPrice(p, this, this.price, null);
            }
            if (this.priceMessage != null && !this.priceMessage.isEmpty()) {
                msg = msg.replace("%price%", this.priceMessage);
            }
            if (this.rewardMessage != null && !this.rewardMessage.isEmpty()) {
                msg = msg.replace("%reward%", this.rewardMessage);
            }
        }
        if (this.priceT != null && !Objects.equals(this.priceT.name(), "") && !this.priceT.name().isEmpty()) {
            msg = msg.replace(" %pricetype%", "");
            msg = msg.replace("%pricetype%", "");
        }
        if (this.rewardT != null && !Objects.equals(this.rewardT.name(), "") && !this.rewardT.name().isEmpty()) {
            msg = msg.replace(" %rewardtype%", "");
            msg = msg.replace("%rewardtype%", "");
        }
        msg = msg.replace("%shopitemname%", this.name);
        if (shop != null && this.item != null) {
            String itemTitle = ClassManager.manager.getItemStackTranslator().readItemName(this.item);
            if (itemTitle != null) {
                String name = itemTitle;
                msg = msg.replace("%itemname%", name);
            }
            if (msg.contains("%amount%")) {
                msg = msg.replace("%amount%", String.valueOf(this.item.getAmount()));
            }
            if (msg.contains("%material%")) {
                msg = msg.replace("%material%", ClassManager.manager.getItemStackTranslator().readMaterial(this.item));
            }
            if (msg.contains("%rewardraw%")) {
                msg = msg.replace("%rewardraw%", String.valueOf(this.reward));
            }
            if (msg.contains("%priceraw%")) {
                msg = msg.replace("%priceraw%", String.valueOf(this.price));
            }
            if (msg.contains("%original_price%")) {
                msg = msg.replace("%original_price%", MathTools.displayNumber((double)((Double)this.price), GenesisPriceType.Money));
            }
            if (msg.contains("%original_reward%")) {
                msg = msg.replace("%original_reward%", MathTools.displayNumber((double)((Double)this.price), GenesisPriceType.Points));
            }
            if (msg.contains("%price_")) {
                String[] parts;
                String placeholder = "%price_" + msg.split("%price_")[1].split("%")[0] + "%";
                if (!List.of("%reward_shift_left%", "%price_shift_left%", "%reward_shift_right%", "%price_shift_right%").contains(placeholder) && (parts = placeholder.split("_")).length == 3) {
                    String shopName = parts[1];
                    String itemId = parts[2];
                    ClassManager.manager.getBugFinder().warn(String.format("[%s:%s] We do not have support for placeholders like %s at the moment. This feature is work in progress though!", shop.getShopName(), this.getName(), placeholder));
                }
            }
        }
        return msg;
    }

    public void updateShop(GenesisShop shop, ItemStack menuitem, ClassManager manager, boolean addItem) {
        if (manager.getSettings().getPropertyBoolean(0, this) && !shop.isCustomizable() && this.isExtraPermissionExisting(null)) {
            shop.setCustomizable(true);
        }
        if (!shop.isCustomizable()) {
            for (GenesisBuy b : shop.getItems()) {
                if (b == null || b.getInventoryLocation() != this.getInventoryLocation() && !b.containsConditions()) continue;
                shop.setCustomizable(true);
                break;
            }
        }
        if (menuitem.hasItemMeta()) {
            if (ClassManager.manager.getItemStackTranslator().checkItemStackForFeatures(shop, this, menuitem)) {
                shop.setCustomizable(true);
                shop.setDisplaying(true);
            }
            if (!this.isFixItem()) {
                ClassManager.manager.getItemStackTranslator().translateItemStack(this, shop, null, menuitem, null, false);
            }
        }
        this.setItem(menuitem, !ClassManager.manager.getItemStackTranslator().checkItemStackForFeatures(shop, this, menuitem));
        if (this.isFixItem()) {
            ClassManager.manager.getItemStackTranslator().translateItemStack(null, null, null, this.getItem(), null, true);
        }
        if (addItem) {
            shop.getItems().add(this);
        }
    }

    public void putSpecialInformation(Plugin plugin, Object information) {
        if (plugin != null && information != null) {
            if (this.specialInformation == null) {
                this.specialInformation = new HashMap();
            }
            this.specialInformation.put(plugin, information);
        }
    }

    public void setItem(ItemStack item, boolean fixItem) {
        this.item = item;
        this.fixItem = fixItem;
    }

    public void click(Player p, GenesisShop shop, GenesisShopHolder holder, ClickType clickType, InventoryClickEvent event, Genesis plugin) {
        if (!this.hasPermission(p, true, clickType)) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(7, this, null));
            return;
        }
        if (!this.meetsCondition(holder, p)) {
            return;
        }
        this.purchaseTry(p, shop, holder, clickType, event, plugin);
    }

    public void purchaseTry(Player p, GenesisShop shop, GenesisShopHolder holder, ClickType clickType, InventoryClickEvent event, Genesis plugin) {
        GenesisPlayerPurchaseEvent e1 = new GenesisPlayerPurchaseEvent(p, shop, this, clickType);
        Bukkit.getPluginManager().callEvent((Event)e1);
        if (e1.isCancelled()) {
            return;
        }
        GenesisRewardType rewardType = this.getRewardType(clickType);
        GenesisPriceType priceType = this.getPriceType(clickType);
        if (!rewardType.canBuy(p, this, true, this.getReward(clickType), clickType)) {
            return;
        }
        if (!priceType.hasPrice(p, this, this.getPrice(clickType), clickType, true)) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(8, this, null));
            return;
        }
        this.purchaseTask(p, shop, holder, clickType, rewardType, priceType, event, plugin);
    }

    public void purchaseTask(Player p, GenesisShop shop, GenesisShopHolder holder, ClickType clickType, GenesisRewardType rewardType, GenesisPriceType priceType, InventoryClickEvent event, Genesis plugin) {
        if (this.inputType != null) {
            this.inputType.forceInput(p, shop, this, holder, clickType, rewardType, priceType, event, plugin);
            return;
        }
        if (ClassManager.manager.getSettings().getPurchaseAsync()) {
            CrossScheduler.runAsync(new ShopItemPurchaseTask(p, this, shop, holder, clickType, rewardType, priceType, event));
        } else {
            this.purchase(p, shop, holder, clickType, rewardType, priceType, event, plugin, false);
        }
    }

    @Deprecated
    public void purchase(Player p, GenesisShop shop, GenesisShopHolder holder, ClickType clickType, GenesisRewardType rewardType, GenesisPriceType priceType, InventoryClickEvent event, Genesis plugin, boolean async) {
        boolean needUpdate;
        String message = this.getMessage(clickType);
        if (message != null) {
            message = this.transformMessage(message, shop, p);
        }
        String o = null;
        if (!rewardType.overridesPrice()) {
            o = priceType.takePrice(p, this, this.getPrice(clickType), clickType);
        }
        if (plugin.getClassManager().getSettings().getPropertyBoolean(3, this)) {
            p.closeInventory();
        }
        if (!priceType.overridesReward()) {
            if (async && rewardType.allowAsync()) {
                CrossScheduler.run(() -> rewardType.giveReward(p, this, this.getReward(clickType), clickType));
            } else {
                rewardType.giveReward(p, this, this.getReward(clickType), clickType);
            }
        }
        if (rewardType.overridesPrice()) {
            o = rewardType.getPriceReturnMessage(p, this, priceType, clickType);
        }
        if (message != null) {
            if (o != null && !o.equals("") && message.contains("%left%")) {
                message = message.replace("%left%", o);
            }
            message = plugin.getClassManager().getStringManager().transform(message, this, shop, holder, p);
        }
        boolean bl = needUpdate = rewardType.mightNeedShopUpdate() || priceType.mightNeedShopUpdate();
        if (plugin.getClassManager().getSettings().getTransactionLogEnabled()) {
            plugin.getClassManager().getTransactionLog().addTransaction(p, this, clickType);
        }
        GenesisPlayerPurchasedEvent e2 = new GenesisPlayerPurchasedEvent(p, shop, this, clickType);
        Bukkit.getPluginManager().callEvent((Event)e2);
        ClassManager.manager.getMessageHandler().sendMessageDirect(message, (CommandSender)p);
        if (priceType != GenesisPriceType.Nothing) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(5, this, null));
        } else if (rewardType.isActualReward()) {
            Misc.playSound(p, ClassManager.manager.getSettings().getPropertyString(6, this, null));
        }
        if (shop.isCustomizable() && needUpdate && event != null && p.getOpenInventory() == event.getView()) {
            if (async) {
                CrossScheduler.run(() -> shop.updateInventory(event.getInventory(), holder, p, plugin.getClassManager(), holder.getPage(), holder.getHighestPage(), false));
            } else {
                shop.updateInventory(event.getInventory(), holder, p, plugin.getClassManager(), holder.getPage(), holder.getHighestPage(), false);
            }
        }
    }

    @Generated
    public GenesisShop getShop() {
        return this.shop;
    }

    @Generated
    public void setShop(GenesisShop shop) {
        this.shop = shop;
    }

    @Generated
    public boolean isFixItem() {
        return this.fixItem;
    }

    @Generated
    public ItemStack getItem() {
        return this.item;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPriceMessage() {
        return this.priceMessage;
    }

    @Generated
    public String getRewardMessage() {
        return this.rewardMessage;
    }

    @Generated
    public GenesisCondition getCondition() {
        return this.condition;
    }
}

