/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.api;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.api.GenesisAddonConfig;
import studio.magemonkey.genesis.api.GenesisAddonStorage;

public abstract class GenesisAddon
extends JavaPlugin {
    private Genesis bs;
    private boolean b = false;

    public void onEnable() {
        double aoWorth;
        this.b = false;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Genesis");
        if (plugin == null) {
            this.printSevere("Genesis was not found... you need it in order to run " + this.getAddonName() + "! Get it here: https://www.spigotmc.org/resources/104824/. Version v" + this.getRequiredGenesisVersion() + " or newer is required!");
            this.printInfo("Disabling Addon...");
            this.b = true;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.bs = (Genesis)plugin;
        double bsWorth = this.getWorth(this.bs.getDescription().getVersion());
        if (bsWorth < (aoWorth = this.getWorth(this.getRequiredGenesisVersion()))) {
            this.printSevere("Genesis was found but it seems to be outdated... you need v" + this.getRequiredGenesisVersion() + " or newer in order to run " + this.getAddonName() + "! Get it here: https://www.spigotmc.org/resources/104824/");
            this.printInfo("Disabling Addon...");
            this.b = true;
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.bs.getAPI().addEnabledAddon(this);
        Genesis.log("Enabling Addon " + this.getAddonName());
        this.enable();
    }

    public void onDisable() {
        if (this.b) {
            return;
        }
        Genesis.log("Disabling Addon " + this.getAddonName());
        this.disable();
    }

    protected void enable() {
        this.enableAddon();
    }

    protected void disable() {
        this.disableAddon();
    }

    public void reload(CommandSender sender) {
        this.genesisReloaded(sender);
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Reloaded Genesis Addon " + String.valueOf(ChatColor.GOLD) + this.getAddonName());
    }

    public void printSevere(String msg) {
        Bukkit.getLogger().severe("[" + this.getAddonName() + "] " + msg);
    }

    public void printWarning(String msg) {
        Bukkit.getLogger().warning("[" + this.getAddonName() + "] " + msg);
    }

    public void printInfo(String msg) {
        Bukkit.getLogger().info("[" + this.getAddonName() + "] " + msg);
    }

    public final Genesis getGenesis() {
        return this.bs;
    }

    protected double getWorth(String s) {
        try {
            if (s == null || s.isBlank()) {
                return 0.0;
            }
            s = s.replace("-SNAPSHOT", "");
            double x = 0.0;
            String[] parts = s.replace(".", ":").split(":");
            x += (double)Integer.parseInt(parts[0].trim());
            if (parts.length == 2) {
                x += 0.1 * (double)Integer.parseInt(parts[1].trim());
            }
            if (parts.length == 3) {
                x += 0.1 * (double)Integer.parseInt(parts[1].trim());
                x += 0.01 * (double)Integer.parseInt(parts[2].trim());
            }
            return x;
        }
        catch (Exception e) {
            this.printWarning("Was not able to get the version of " + s);
            return 1.0;
        }
    }

    public GenesisAddonStorage createStorage(Plugin plugin, String name) {
        return new GenesisAddonConfig(plugin, name);
    }

    public abstract String getAddonName();

    public abstract String getRequiredGenesisVersion();

    public abstract void enableAddon();

    public abstract void genesisFinishedLoading();

    public abstract void disableAddon();

    public abstract void genesisReloaded(CommandSender var1);
}

