/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.genesis.Genesis;
import studio.magemonkey.genesis.api.GenesisAddon;
import studio.magemonkey.genesis.api.InventoryUtil;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisCustomActions;
import studio.magemonkey.genesis.core.GenesisCustomLink;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.core.GenesisShopHolder;
import studio.magemonkey.genesis.core.GenesisShops;
import studio.magemonkey.genesis.core.conditions.GenesisConditionType;
import studio.magemonkey.genesis.core.prices.GenesisPriceType;
import studio.magemonkey.genesis.core.rewards.GenesisRewardType;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.GenesisConfigShop;
import studio.magemonkey.genesis.managers.item.ItemDataPart;

public class GenesisAPI {
    private final Genesis plugin;
    private List<GenesisAddon> enabledAddons;

    public GenesisAPI(Genesis plugin) {
        this.plugin = plugin;
    }

    public GenesisAddon getAddon(String addonname) {
        if (this.enabledAddons != null) {
            for (GenesisAddon addon : this.enabledAddons) {
                if (!addon.getAddonName().equalsIgnoreCase(addonname)) continue;
                return addon;
            }
        }
        return null;
    }

    public boolean isValidShop(Object v) {
        if (v == null) {
            return false;
        }
        return this.isValidShop(InventoryUtil.getTopInventory(v));
    }

    public boolean isValidShop(Inventory i) {
        if (i == null) {
            return false;
        }
        return i.getHolder() instanceof GenesisShopHolder;
    }

    public GenesisShop getShop(String name) {
        if (this.plugin.getClassManager() == null) {
            return null;
        }
        if (this.plugin.getClassManager().getShops() == null) {
            return null;
        }
        return this.plugin.getClassManager().getShops().getShop(name.toLowerCase());
    }

    public void openShop(Player p, String name) {
        GenesisShop shop = this.getShop(name);
        if (shop == null) {
            Genesis.log("[API] Error: Tried to open Shop " + name + " but it was not found...");
            return;
        }
        this.openShop(p, shop);
    }

    public void openShop(Player p, GenesisShop shop) {
        this.plugin.getClassManager().getShops().openShop(p, shop);
    }

    public void updateInventory(Player p) {
        this.updateInventory(p, false);
    }

    public void updateInventory(Player p, boolean forceNewCreation) {
        if (this.isValidShop(p.getOpenInventory())) {
            GenesisShopHolder holder = (GenesisShopHolder)InventoryUtil.getTopInventory(p.getOpenInventory()).getHolder();
            if (forceNewCreation) {
                holder.getShop().openInventory(p, holder.getPage(), false);
            } else {
                holder.getShop().updateInventory(InventoryUtil.getTopInventory(p.getOpenInventory()), holder, p, ClassManager.manager, holder.getPage(), holder.getHighestPage(), false);
            }
        }
    }

    public GenesisShops getShopHandler() {
        return this.plugin.getClassManager().getShops();
    }

    public void addShop(GenesisShop shop) {
        this.getShopHandler().addShop(shop);
    }

    public int createNextShopId() {
        return this.getShopHandler().createId();
    }

    public void addItemToShop(ItemStack menuItem, GenesisBuy shopItem, GenesisShop shop) {
        shop.addShopItem(shopItem, menuItem, ClassManager.manager);
    }

    public void finishedAddingItemsToShop(GenesisShop shop) {
        shop.finishedAddingItems();
    }

    public void registerConditionType(GenesisConditionType type) {
        type.register();
    }

    public void registerPriceType(GenesisPriceType type) {
        type.register();
    }

    public void registerRewardType(GenesisRewardType type) {
        type.register();
    }

    public void registerItemDataPart(ItemDataPart part) {
        part.register();
    }

    public GenesisBuy createGenesisBuy(String name, GenesisRewardType rewardType, GenesisPriceType priceType, Object reward, Object price, String msg, int location, String permission) {
        return new GenesisBuy(rewardType, priceType, reward, price, msg, location, permission, name);
    }

    public GenesisBuy createGenesisBuyCustom(String name, GenesisRewardType rewardType, GenesisPriceType priceType, GenesisCustomLink reward, Object price, String msg, int location, String permission) {
        return new GenesisBuy(rewardType, priceType, reward, price, msg, location, permission, name);
    }

    public GenesisBuy createGenesisBuy(GenesisRewardType rewardType, GenesisPriceType priceType, Object reward, Object price, String msg, int location, String permission) {
        return new GenesisBuy(rewardType, priceType, reward, price, msg, location, permission, "");
    }

    public GenesisBuy createGenesisBuyCustom(GenesisRewardType rewardType, GenesisPriceType priceType, GenesisCustomLink reward, Object price, String msg, int location, String permission) {
        return new GenesisBuy(rewardType, priceType, reward, price, msg, location, permission, "");
    }

    public GenesisCustomLink createGenesisCustomLink(GenesisCustomActions actions, int actionId) {
        return new GenesisCustomLink(actionId, actions);
    }

    public HashMap<GenesisShop, List<GenesisBuy>> getAllShopItems() {
        HashMap<GenesisShop, List<GenesisBuy>> all = new HashMap<GenesisShop, List<GenesisBuy>>();
        for (int i : this.plugin.getClassManager().getShops().getShops().keySet()) {
            GenesisShop shop = this.plugin.getClassManager().getShops().getShop(i);
            if (shop == null) continue;
            ArrayList<GenesisBuy> items = new ArrayList<GenesisBuy>();
            for (GenesisBuy buy : shop.getItems()) {
                if (buy == null || buy.getItem() == null) continue;
                items.add(buy);
            }
            all.put(shop, items);
        }
        return all;
    }

    public HashMap<GenesisConfigShop, List<GenesisBuy>> getAllShopItems(String configOption) {
        HashMap<GenesisConfigShop, List<GenesisBuy>> all = new HashMap<GenesisConfigShop, List<GenesisBuy>>();
        for (int i : this.plugin.getClassManager().getShops().getShops().keySet()) {
            GenesisShop shop = this.plugin.getClassManager().getShops().getShop(i);
            if (shop == null | !(shop instanceof GenesisConfigShop)) continue;
            GenesisConfigShop sho = (GenesisConfigShop)shop;
            ArrayList<GenesisBuy> items = new ArrayList<GenesisBuy>();
            for (GenesisBuy buy : shop.getItems()) {
                if (buy == null || buy.getItem() == null || !buy.getConfigurationSection(sho).getBoolean(configOption) && buy.getConfigurationSection(sho).getInt(configOption) == 0) continue;
                items.add(buy);
            }
            all.put(sho, items);
        }
        return all;
    }

    protected void addEnabledAddon(GenesisAddon addon) {
        Plugin addonplugin = Bukkit.getPluginManager().getPlugin(addon.getAddonName());
        if (addonplugin == null) {
            return;
        }
        if (this.enabledAddons == null) {
            this.enabledAddons = new ArrayList<GenesisAddon>();
        }
        if (this.enabledAddons.contains((Object)addon)) {
            return;
        }
        this.enabledAddons.add(addon);
    }

    @Generated
    public List<GenesisAddon> getEnabledAddons() {
        return this.enabledAddons;
    }
}

