/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.genesis.api.GenesisAPI;
import studio.magemonkey.genesis.api.GenesisAddon;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.events.GenesisReloadedEvent;
import studio.magemonkey.genesis.folia.CrossScheduler;
import studio.magemonkey.genesis.inbuiltaddons.InbuiltAddonLoader;
import studio.magemonkey.genesis.listeners.InventoryListener;
import studio.magemonkey.genesis.listeners.PlayerListener;
import studio.magemonkey.genesis.listeners.SignListener;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.CommandManager;
import studio.magemonkey.genesis.managers.config.ConfigKeyCompleter;

public class Genesis
extends JavaPlugin {
    public static final String NAME = "Genesis";
    private ClassManager manager;
    private InventoryListener il;
    private SignListener sl;
    private PlayerListener pl;
    private GenesisAPI api;

    public static void log(String s) {
        Bukkit.getLogger().info("[Genesis] " + s);
    }

    public static void debug(String s) {
        if (ClassManager.manager.getSettings().isDebugEnabled()) {
            Genesis.log(s);
        }
    }

    public void onEnable() {
        Genesis.log("Loading data...");
        this.manager = new ClassManager(this);
        this.api = new GenesisAPI(this);
        CommandManager commander = new CommandManager();
        if (this.getCommand("gen") != null) {
            this.getCommand("gen").setExecutor((CommandExecutor)commander);
            this.getCommand("gen").setTabCompleter((TabCompleter)commander);
        }
        if (this.getCommand("genesis") != null) {
            this.getCommand("genesis").setExecutor((CommandExecutor)commander);
            this.getCommand("genesis").setTabCompleter((TabCompleter)commander);
        }
        if (this.getCommand("shop") != null) {
            this.getCommand("shop").setExecutor((CommandExecutor)commander);
            this.getCommand("shop").setTabCompleter((TabCompleter)commander);
        }
        this.il = new InventoryListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.il, (Plugin)this);
        this.sl = new SignListener(this.manager.getSettings().getSignsEnabled(), this);
        this.getServer().getPluginManager().registerEvents((Listener)this.sl, (Plugin)this);
        this.pl = new PlayerListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.pl, (Plugin)this);
        CrossScheduler.runTaskLaterAsync(() -> {
            new InbuiltAddonLoader().load(this);
            this.getClassManager().setupDependentClasses();
        }, 3L);
        ConfigKeyCompleter.checkConfig();
        ConfigKeyCompleter.checkLanguages();
    }

    public void onDisable() {
        this.closeShops();
        this.unloadClasses();
        Genesis.log("Disabling... bye!");
    }

    public ClassManager getClassManager() {
        return this.manager;
    }

    public SignListener getSignListener() {
        return this.sl;
    }

    public InventoryListener getInventoryListener() {
        return this.il;
    }

    public PlayerListener getPlayerListener() {
        return this.pl;
    }

    public GenesisAPI getAPI() {
        return this.api;
    }

    public void reloadPlugin(CommandSender sender) {
        this.closeShops();
        this.reloadConfig();
        this.manager.getMessageHandler().reloadConfig();
        if (this.manager.getShops() != null) {
            CrossScheduler.runTaskLaterAsync(() -> {
                for (String s : this.manager.getShops().getShopIds().keySet()) {
                    GenesisShop shop = this.manager.getShops().getShops().get(s);
                    if (shop == null) continue;
                    shop.reloadShop();
                }
            }, 3L);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.api.isValidShop(p.getOpenInventory())) continue;
            p.closeInventory();
        }
        this.sl.setSignsEnabled(false);
        this.unloadClasses();
        this.manager = new ClassManager(this);
        if (this.api.getEnabledAddons() != null) {
            for (GenesisAddon addon : this.api.getEnabledAddons()) {
                addon.reload(sender);
            }
        }
        this.manager.setupDependentClasses();
        GenesisReloadedEvent event = new GenesisReloadedEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    private void unloadClasses() {
        CrossScheduler.cancelTasks((Plugin)this);
        if (this.manager == null) {
            return;
        }
        if (this.manager.getSettings() == null) {
            return;
        }
        if (this.manager.getStorageManager() != null) {
            this.manager.getStorageManager().saveConfig();
        }
        if (this.manager.getItemDataStorage() != null) {
            this.manager.getItemDataStorage().saveConfig();
        }
        if (this.manager.getSettings().getTransactionLogEnabled()) {
            this.manager.getTransactionLog().saveConfig();
        }
        if (this.manager.getSettings().getServerPingingEnabled(true)) {
            this.manager.getServerPingingManager().getServerPingingRunnableHandler().stop();
            this.manager.getServerPingingManager().clear();
        }
        if (this.manager.getAutoRefreshHandler() != null) {
            this.manager.getAutoRefreshHandler().stop();
        }
    }

    private void closeShops() {
        if (this.manager == null || this.manager.getShops() == null || this.manager.getShops().getShops() == null) {
            return;
        }
        for (int i : this.manager.getShops().getShops().keySet()) {
            GenesisShop shop = this.manager.getShops().getShops().get(i);
            if (shop == null) continue;
            shop.close();
        }
    }

    public static long getVersionWeight(String version) {
        if (!version.matches("\\d+(\\.\\d+){1,2}")) {
            return 0L;
        }
        String[] parts = version.split("\\.");
        long weight = 0L;
        if (parts.length >= 1) {
            weight += Long.parseLong(parts[0]) * 10000L;
        }
        if (parts.length >= 2) {
            weight += Long.parseLong(parts[1]) * 100L;
        }
        if (parts.length >= 3) {
            weight += Long.parseLong(parts[2]);
        }
        return weight;
    }

    public static long getVersionWeight() {
        String version = Bukkit.getServer().getBukkitVersion();
        String[] parts = version.split("-");
        String versionPart = parts[0];
        long weight = Genesis.getVersionWeight(versionPart);
        if (weight == 0L) {
            throw new IllegalArgumentException("Invalid version format: " + version);
        }
        return weight;
    }
}

