package studio.magemonkey.genesis.managers.item;

import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.misc.InputReader;

import java.util.List;

public class ItemDataPartCustomModelData extends ItemDataPart {
    @Override
    public ItemStack transform(ItemStack item, String usedName, String argument) {
        int customModelData = InputReader.getInt(argument, -1);
        if (customModelData == -1) {
            ClassManager.manager.getBugFinder()
                    .severe("Mistake in Config: '" + argument + "' is not a valid '" + usedName
                            + "'. It needs to be a number like '1', '12' or '64'.");
            return item;
        }
        ItemMeta meta = item.getItemMeta();
        meta.setCustomModelData(customModelData);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public boolean isSimilar(ItemStack shopItem, ItemStack playerItem, GenesisBuy buy, Player p) {
        if (shopItem.hasItemMeta() == playerItem.hasItemMeta()) {
            // If both don't have item meta, they should be considered similar here
            if (!shopItem.hasItemMeta()) return true;

            boolean modelPresenceMatch =
                    shopItem.getItemMeta().hasCustomModelData() == playerItem.getItemMeta().hasCustomModelData();
            if (modelPresenceMatch) {
                // If both have item meta, we can check the custom model data, otherwise, they don't have model data and are "similar"
                if (!shopItem.getItemMeta().hasCustomModelData()) return true;

                return shopItem.getItemMeta().getCustomModelData() == playerItem.getItemMeta().getCustomModelData();
            }

            // If the model presence does not match, they are similar only if the shop item does not have custom model data
            return !shopItem.getItemMeta().hasCustomModelData();
        }

        // If the hasItemMeta does not match, they are similar only if the shop item does not have item meta
        return !shopItem.hasItemMeta();
    }

    @Override
    public List<String> read(ItemStack i, List<String> output) {
        if (i.hasItemMeta()) {
            int d = i.getItemMeta().getCustomModelData();
            if (d != -1) {
                output.add("CustomModelData:" + d);
            }
        }
        return output;
    }

    @Override
    public int getPriority() {
        return PRIORITY_NORMAL;
    }

    @Override
    public boolean removeSpaces() {
        return false;
    }

    @Override
    public String[] createNames() {
        return new String[]{"CustomModelData"};
    }
}
