/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.util;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.ability.Ability;
import dev.aurelium.auraskills.api.mana.ManaAbility;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.stat.Stat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import studio.magemonkey.divinity.api.DivinityAPI;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;

public class TabCacher {
    public static UUID GlobalUUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    public static final Map<UUID, TabCacher> PlayerTabs = new TreeMap<UUID, TabCacher>();
    public final Map<String, List<String>> CachedTabs = new TreeMap<String, List<String>>();

    public static void cache(UUID uuid, String key, List<String> tabList) {
        PlayerTabs.putIfAbsent(uuid, new TabCacher());
        TabCacher.PlayerTabs.get((Object)uuid).CachedTabs.put(key, tabList);
    }

    public static boolean isNotCached(UUID uuid, String key) {
        return !PlayerTabs.containsKey(uuid) || !TabCacher.PlayerTabs.get((Object)uuid).CachedTabs.containsKey(key);
    }

    public static TabCacher get(UUID uuid) {
        return PlayerTabs.get(uuid);
    }

    public static void clearTabs(UUID uuid) {
        PlayerTabs.remove(uuid);
    }

    public static void clearTabs(UUID uuid, String key) {
        TabCacher.PlayerTabs.get((Object)uuid).CachedTabs.remove(key);
    }

    public static List<String> getTabs(UUID uuid, String key, String arg) {
        ArrayList<String> entries;
        block39: {
            block40: {
                entries = new ArrayList<String>();
                if (!TabCacher.isNotCached(uuid, key)) break block39;
                switch (key) {
                    case "items": {
                        for (Material material : Material.values()) {
                            if (material.isAir()) continue;
                            entries.add(material.toString().toLowerCase());
                        }
                        if (!Bukkit.getPluginManager().isPluginEnabled("Divinity")) break;
                        DivinityAPI.getModuleManager().getCustomItemsManager().getItems().forEach(k -> entries.add("DIVINITY_" + k.getId().toLowerCase()));
                        break;
                    }
                    case "professions": {
                        entries.addAll(ProfessionsCfg.getMap().keySet());
                        break;
                    }
                    case "fabled": {
                        if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) break;
                        entries.addAll(Fabled.getClasses().keySet());
                        break;
                    }
                    case "mcmmo": {
                        if (!Bukkit.getPluginManager().isPluginEnabled("mcMMO")) break;
                        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                            entries.add(primarySkillType.name().toLowerCase());
                        }
                        break;
                    }
                    case "jobs": {
                        if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) break;
                        for (Job job : Jobs.getJobs()) {
                            entries.add(job.getName().toLowerCase());
                        }
                        break;
                    }
                    case "aura_abilities": 
                    case "aura_mana_abilities": 
                    case "aura_skills": 
                    case "aura_stats": {
                        if (!Bukkit.getPluginManager().isPluginEnabled("AuraSkills") && !Bukkit.getPluginManager().isPluginEnabled("AureliumSkills")) break;
                        switch (key) {
                            case "aura_abilities": {
                                for (Ability ability : AuraSkillsApi.get().getGlobalRegistry().getAbilities()) {
                                    entries.add(ability.getId().getKey());
                                }
                                break block40;
                            }
                            case "aura_mana_abilities": {
                                for (ManaAbility manaAbility : AuraSkillsApi.get().getGlobalRegistry().getManaAbilities()) {
                                    entries.add(manaAbility.getId().getKey());
                                }
                                break block40;
                            }
                            case "aura_skills": {
                                for (Skill skill : AuraSkillsApi.get().getGlobalRegistry().getSkills()) {
                                    entries.add(skill.getId().getKey());
                                }
                                break block40;
                            }
                            case "aura_stats": {
                                for (Stat stat : AuraSkillsApi.get().getGlobalRegistry().getStats()) {
                                    entries.add(stat.getId().getKey());
                                }
                            }
                        }
                    }
                }
            }
            TabCacher.cache(uuid, key, entries);
        }
        ArrayList cachedTabsCopy = new ArrayList(TabCacher.PlayerTabs.get((Object)uuid).CachedTabs.get(key));
        for (String entry : cachedTabsCopy) {
            if (!entry.toLowerCase().startsWith(arg.toLowerCase())) continue;
            entries.add(entry);
        }
        return entries;
    }

    public static List<String> getProfessionTabs(UUID uuid, String key, String arg) {
        ArrayList<String> entries = new ArrayList<String>();
        if (TabCacher.isNotCached(uuid, key)) {
            if (Bukkit.getPluginManager().isPluginEnabled("Divinity")) {
                DivinityAPI.getModuleManager().getCustomItemsManager().getItems().forEach(k -> entries.add("DIVINITY_" + k.getId().toLowerCase()));
            }
            TabCacher.cache(uuid, key, entries);
        }
        ArrayList cachedTabsCopy = new ArrayList(TabCacher.PlayerTabs.get((Object)uuid).CachedTabs.get(key));
        for (String entry : cachedTabsCopy) {
            if (!entry.toLowerCase().startsWith(arg.toLowerCase())) continue;
            entries.add(entry);
        }
        return entries;
    }

    public static List<String> getConditionsTabs(String[] args) {
        ArrayList<String> entries = new ArrayList<String>();
        if (args.length == 1) {
            entries.add("<conditionKey>");
            entries.add("professions");
            if (Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                entries.add("fabled");
            }
            if (Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
                entries.add("mcmmo");
            }
            if (Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                entries.add("jobs");
            }
            if (Bukkit.getPluginManager().isPluginEnabled("AuraSkills") || Bukkit.getPluginManager().isPluginEnabled("AureliumSkills")) {
                entries.add("aura_abilities");
                entries.add("aura_mana_abilities");
                entries.add("aura_skills");
                entries.add("aura_stats");
            }
        } else if (args.length == 2) {
            entries.add("<conditionValue>");
            switch (args[0].toLowerCase()) {
                case "professions": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "professions", args[1]));
                    break;
                }
                case "fabled": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "fabled", args[1]));
                    break;
                }
                case "mcmmo": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "mcmmo", args[1]));
                    break;
                }
                case "jobs": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "jobs", args[1]));
                    break;
                }
                case "aura_abilities": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "aura_abilities", args[1]));
                    break;
                }
                case "aura_mana_abilities": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "aura_mana_abilities", args[1]));
                    break;
                }
                case "aura_skills": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "aura_skills", args[1]));
                    break;
                }
                case "aura_stats": {
                    entries.addAll(TabCacher.getTabs(GlobalUUID, "aura_stats", args[1]));
                }
            }
        } else if (args.length == 3) {
            entries.add("<level>");
            entries.add("1");
            entries.add("10");
            entries.add("25");
            entries.add("50");
            entries.add("100");
        }
        return entries;
    }

    public static List<String> getEnchantmentsTab(String[] args) {
        ArrayList<String> entries = new ArrayList<String>();
        if (args.length == 1) {
            entries.add("<enchantment>");
            for (Enchantment enchantment : Enchantment.values()) {
                entries.add(enchantment.getKey().getKey().toLowerCase());
            }
        } else if (args.length == 2) {
            entries.add("<level>");
            entries.add("1");
            entries.add("2");
            entries.add("3");
            entries.add("4");
            entries.add("5");
        }
        return entries;
    }

    public static List<String> getFlagsTab(String[] args) {
        ArrayList<String> entries = new ArrayList<String>();
        if (args.length == 1) {
            entries.add("<flag>");
            for (ItemFlag flag : ItemFlag.values()) {
                entries.add(flag.name().toLowerCase());
            }
        }
        return entries;
    }
}

