/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.fusion.Fusion;

public class PlayerUtil {
    public static int getPermOption(Player player, String permission) {
        int ret = 0;
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String ps = perm.getPermission();
            if (!ps.startsWith(permission.toLowerCase())) continue;
            String end = ps.substring(ps.lastIndexOf(46) + 1);
            try {
                ret = Math.max(ret, Integer.parseInt(end));
            }
            catch (NumberFormatException e) {
                Fusion.getInstance().log.warning("Could not get numeric permission value from '" + end + "'");
            }
        }
        return ret;
    }

    public static double getProfessionExpBonusThroughPermissions(Player player, String profession) {
        int chance = 0;
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String ps = perm.getPermission();
            if (!ps.startsWith("fusion.experience." + profession.toLowerCase() + ".boost")) continue;
            String end = ps.substring(ps.lastIndexOf(46) + 1);
            try {
                chance += Integer.parseInt(end);
            }
            catch (NumberFormatException e) {
                Fusion.getInstance().log.warning("Could not get numeric permission value from '" + end + "'");
            }
        }
        return (double)chance / 100.0;
    }

    public static List<String> getPlayerNames() {
        ArrayList<String> entries = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> entries.add(player.getName()));
        return entries;
    }

    public static Collection<ItemStack> getPlayerItems(InventoryHolder player) {
        ItemStack[] contents = ItemUtils.compact((boolean)false, (ItemStack[])player.getInventory().getContents());
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(contents.length);
        for (ItemStack content : contents) {
            if (content == null) continue;
            result.add(content);
        }
        return result;
    }
}

