/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.hook;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import studio.magemonkey.codex.CodexEngine;

public class VaultHook {
    private static BukkitTask task;
    private static Map<UUID, Pair<Double, LocalDateTime>> storedBalances;
    private static int thresholdSeconds;

    public static double getBalance(Player player) {
        if (storedBalances.containsKey(player.getUniqueId())) {
            Pair<Double, LocalDateTime> balanceData = storedBalances.get(player.getUniqueId());
            double balance = (Double)balanceData.getLeft();
            LocalDateTime timestamp = (LocalDateTime)balanceData.getRight();
            if (timestamp.plusSeconds(thresholdSeconds).isBefore(LocalDateTime.now())) {
                double updatedBalance = CodexEngine.get().getVault() != null ? CodexEngine.get().getVault().getBalance((OfflinePlayer)player) : 0.0;
                storedBalances.put(player.getUniqueId(), (Pair<Double, LocalDateTime>)Pair.of((Object)updatedBalance, (Object)LocalDateTime.now()));
                return updatedBalance;
            }
            return balance;
        }
        double balance = CodexEngine.get().getVault() != null ? CodexEngine.get().getVault().getBalance((OfflinePlayer)player) : 0.0;
        storedBalances.put(player.getUniqueId(), (Pair<Double, LocalDateTime>)Pair.of((Object)balance, (Object)LocalDateTime.now()));
        return balance;
    }

    public static void startMoneyUpdateTask() {
        task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)CodexEngine.get(), () -> {
            for (UUID uuid : storedBalances.keySet()) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null || !player.isOnline()) continue;
                VaultHook.getBalanceAsync(player, balance -> storedBalances.put(uuid, (Pair<Double, LocalDateTime>)Pair.of((Object)balance, (Object)LocalDateTime.now())));
            }
        }, (long)thresholdSeconds * 20L, (long)thresholdSeconds * 20L);
    }

    public static void cancelMoneyUpdateTask() {
        if (task != null) {
            task.cancel();
            task = null;
        }
    }

    private static void getBalanceAsync(Player player, Consumer<Double> moneyConsumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CodexEngine.get(), () -> {
            double balance = CodexEngine.get().getVault() != null ? CodexEngine.get().getVault().getBalance((OfflinePlayer)player) : 0.0;
            moneyConsumer.accept(balance);
        });
    }

    static {
        storedBalances = new HashMap<UUID, Pair<Double, LocalDateTime>>();
        thresholdSeconds = 10;
    }
}

